/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.constants.CTConstants;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.display.CTDisplayRendererRegistry;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleLocalization;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.sql.CTSQLModeThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.change.tracking.model.CTEntry"}, service={ModelDocumentContributor.class})
public class CTEntryModelDocumentContributor
implements ModelDocumentContributor<CTEntry> {
    private static final Log _log = LogFactoryUtil.getLog(CTEntryModelDocumentContributor.class);
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTDisplayRendererRegistry _ctDisplayRendererRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Localization _localization;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(Document document, CTEntry ctEntry) {
        document.addKeyword("companyId", ctEntry.getCompanyId());
        document.addDate("createDate", ctEntry.getCreateDate());
        document.addDate("modified", ctEntry.getModifiedDate());
        User user = this._userLocalService.fetchUser(ctEntry.getUserId());
        if (user != null) {
            document.addKeyword("userId", user.getUserId());
            document.addText("userName", user.getFullName());
        }
        document.addKeyword("ctCollectionId", ctEntry.getCtCollectionId());
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctEntry.getCtCollectionId());
        if (ctCollection != null) {
            document.addKeywordSortable("ctCollectionName", ctCollection.getName());
            document.addKeyword("ctCollectionStatus", ctCollection.getStatus());
            document.addLocalizedKeyword("ctCollectionStatusLabel", this._localization.getLocalizationMap((Collection)this._language.getAvailableLocales(), LocaleUtil.getDefault(), WorkflowConstants.getStatusLabel((int)ctCollection.getStatus())), true, true);
            if (ctCollection.getStatus() == 0 || ctCollection.getStatus() == 7) {
                document.addDateSortable("ctCollectionStatusDate", this._getCTCollectionStatusDate(ctCollection));
                User ctCollectionStatusUser = this._userLocalService.fetchUser(ctCollection.getStatusByUserId());
                if (ctCollectionStatusUser != null) {
                    document.addKeyword("ctCollectionStatusUserId", ctCollectionStatusUser.getUserId());
                    document.addKeywordSortable("ctCollectionStatusUserName", ctCollectionStatusUser.getFullName());
                }
            }
        }
        document.addKeyword("modelClassNameId", ctEntry.getModelClassNameId());
        document.addKeyword("modelClassPK", ctEntry.getModelClassPK());
        this._indexModelAttributes(document, ctEntry);
    }

    private <T extends BaseModel<T>> Locale[] _getAvailableLocales(T model, CTDisplayRenderer ctDisplayRenderer) {
        Object[] languageIds = new String[]{};
        if (model != null) {
            languageIds = ctDisplayRenderer.getAvailableLanguageIds(model);
        }
        if (ArrayUtil.isNotEmpty((Object[])languageIds)) {
            return LocaleUtil.fromLanguageIds((String[])languageIds);
        }
        Set locales = this._language.getAvailableLocales();
        return locales.toArray(new Locale[0]);
    }

    private Map<Locale, String> _getChangeTypeLabelMap(Locale[] locales, int changeType) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        String changeTypeLabel = CTConstants.getCTChangeTypeLabel((int)changeType);
        for (Locale locale : locales) {
            map.put(locale, this._language.get(locale, changeTypeLabel));
        }
        return map;
    }

    private Date _getCTCollectionStatusDate(CTCollection ctCollection) {
        block4: {
            if (ctCollection.getStatus() == 0) {
                return ctCollection.getStatusDate();
            }
            try {
                SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(StringBundler.concat((Object[])new Object[]{ctCollection.getCtCollectionId(), "@", ctCollection.getCompanyId()}), "liferay/ct_collection_scheduled_publish", StorageType.PERSISTED);
                if (schedulerResponse != null) {
                    return this._schedulerEngineHelper.getStartTime(schedulerResponse);
                }
            }
            catch (SchedulerException schedulerException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)schedulerException);
            }
        }
        return null;
    }

    private <T extends BaseModel<T>> Group _getGroup(long ctCollectionId, T model) {
        long groupId;
        block28: {
            groupId = 0L;
            if (model instanceof GroupedModel) {
                GroupedModel groupedModel = (GroupedModel)model;
                groupId = groupedModel.getGroupId();
            } else {
                if (model instanceof JournalArticleLocalization) {
                    JournalArticleLocalization journalArticleLocalization = (JournalArticleLocalization)model;
                    try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                        JournalArticle journalArticle = this._journalArticleLocalService.getJournalArticle(journalArticleLocalization.getArticlePK());
                        groupId = journalArticle.getGroupId();
                        break block28;
                    }
                    catch (PortalException portalException) {
                        throw new RuntimeException(portalException);
                    }
                }
                Map modelAttributes = model.getModelAttributes();
                if (modelAttributes.containsKey("groupId")) {
                    groupId = (Long)modelAttributes.get("groupId");
                } else if (modelAttributes.containsKey("plid")) {
                    long plid = (Long)modelAttributes.get("plid");
                    try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                        Layout layout = this._layoutLocalService.fetchLayout(plid);
                        if (layout != null) {
                            groupId = layout.getGroupId();
                        }
                    }
                }
            }
        }
        if (groupId == 0L) {
            return null;
        }
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
            Group group = this._groupLocalService.fetchGroup(groupId);
            return group;
        }
    }

    private <T extends BaseModel<T>> Map<Locale, String> _getTitleMap(long ctCollectionId, CTEntry ctEntry, Locale[] locales) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        if (ctEntry.getChangeType() == 1) {
            ctCollectionId = 0L;
        }
        for (Locale locale : locales) {
            map.put(locale, this._ctDisplayRendererRegistry.getTitle(ctCollectionId, ctEntry, locale));
        }
        return map;
    }

    private Map<Locale, String> _getTypeNameMap(Locale[] locales, long modelClassNameId) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : locales) {
            map.put(locale, this._ctDisplayRendererRegistry.getTypeName(locale, modelClassNameId));
        }
        return map;
    }

    private <T extends BaseModel<T>> void _indexModelAttributes(Document document, CTEntry ctEntry) {
        long ctCollectionId;
        block9: {
            ctCollectionId = ctEntry.getCtCollectionId();
            CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
            if (ctCollection != null) {
                try {
                    ctCollectionId = this._ctDisplayRendererRegistry.getCtCollectionId(ctCollection, ctEntry);
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Throwable)portalException);
                }
            }
        }
        BaseModel model = this._ctDisplayRendererRegistry.fetchCTModel(ctCollectionId, CTSQLModeThreadLocal.CTSQLMode.DEFAULT, ctEntry.getModelClassNameId(), ctEntry.getModelClassPK());
        int changeType = this._ctDisplayRendererRegistry.getChangeType(ctEntry, model);
        document.addKeyword("changeType", changeType);
        Locale[] locales = this._getAvailableLocales(model, this._ctDisplayRendererRegistry.getCTDisplayRenderer(ctEntry.getModelClassNameId()));
        document.addLocalizedText("changeTypeLabel", this._getChangeTypeLabelMap(locales, changeType), true);
        document.addLocalizedText("typeName", this._getTypeNameMap(locales, ctEntry.getModelClassNameId()), true);
        if (model == null) {
            return;
        }
        Group group = this._getGroup(ctCollectionId, model);
        if (group != null) {
            document.addKeyword("groupId", group.getGroupId());
            Map groupNameMap = null;
            try {
                groupNameMap = group.getDescriptiveNameMap();
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException);
                }
                groupNameMap = group.getNameMap();
            }
            document.addLocalizedKeyword("groupName", groupNameMap, false, true);
        }
        document.addLocalizedText("title", this._getTitleMap(ctCollectionId, ctEntry, locales), true);
        document.addKeyword("hideable", this._ctDisplayRendererRegistry.isHideable(model, ctEntry.getModelClassNameId()));
        Map modelAttributes = model.getModelAttributes();
        if (modelAttributes.containsKey("status")) {
            int status = (Integer)modelAttributes.get("status");
            document.addKeyword("status", status);
            document.addLocalizedKeyword("statusLabel", this._localization.getLocalizationMap((Collection)this._language.getAvailableLocales(), LocaleUtil.getDefault(), WorkflowConstants.getStatusLabel((int)status)), true, true);
        }
    }
}

