/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.scheduler;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.scheduler.PublishScheduler;
import com.liferay.change.tracking.scheduler.ScheduledPublishInfo;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PublishScheduler.class})
public class PublishSchedulerImpl
implements PublishScheduler {
    private static final TransactionConfig _transactionConfig;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTCollection)")
    private ModelResourcePermission<CTCollection> _ctCollectionModelResourcePermission;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    public ScheduledPublishInfo getScheduledPublishInfo(CTCollection ctCollection) throws PortalException {
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(this._getSchedulerJobName(ctCollection), "liferay/ct_collection_scheduled_publish", StorageType.PERSISTED);
        if (schedulerResponse == null) {
            return null;
        }
        Message message = schedulerResponse.getMessage();
        return new ScheduledPublishInfo(ctCollection, schedulerResponse.getJobName(), this._schedulerEngineHelper.getStartTime(schedulerResponse), message.getLong("userId"));
    }

    public List<ScheduledPublishInfo> getScheduledPublishInfos() throws PortalException {
        List schedulerResponses = this._schedulerEngineHelper.getScheduledJobs("liferay/ct_collection_scheduled_publish", StorageType.PERSISTED);
        ArrayList<ScheduledPublishInfo> scheduledPublishInfos = new ArrayList<ScheduledPublishInfo>(schedulerResponses.size());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        for (SchedulerResponse schedulerResponse : schedulerResponses) {
            Message message = schedulerResponse.getMessage();
            long ctCollectionId = message.getLong("ctCollectionId");
            CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
            if (ctCollection == null || !this._ctCollectionModelResourcePermission.contains(permissionChecker, (ClassedModel)ctCollection, "VIEW")) continue;
            scheduledPublishInfos.add(new ScheduledPublishInfo(ctCollection, schedulerResponse.getJobName(), this._schedulerEngineHelper.getStartTime(schedulerResponse), message.getLong("userId")));
        }
        return scheduledPublishInfos;
    }

    public void schedulePublish(long ctCollectionId, long userId, Date startDate) throws PortalException {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> this._schedulePublish(ctCollectionId, userId, startDate));
        }
        catch (PortalException portalException) {
            throw portalException;
        }
        catch (Throwable throwable) {
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    public void unschedulePublish(long ctCollectionId) throws PortalException {
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
        if (ctCollection == null || ctCollection.getStatus() == 0) {
            return;
        }
        String jobName = this._getSchedulerJobName(ctCollection);
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(jobName, "liferay/ct_collection_scheduled_publish", StorageType.PERSISTED);
        if (schedulerResponse == null) {
            return;
        }
        this._ctCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)ctCollection, "PUBLISH");
        ctCollection.setStatus(2);
        ctCollection.setStatusByUserId(0L);
        this._ctCollectionLocalService.updateCTCollection(ctCollection);
        this._schedulerEngineHelper.delete(jobName, "liferay/ct_collection_scheduled_publish", StorageType.PERSISTED);
    }

    private String _getSchedulerJobName(CTCollection ctCollection) {
        return StringBundler.concat((Object[])new Object[]{ctCollection.getCtCollectionId(), "@", ctCollection.getCompanyId()});
    }

    private Void _schedulePublish(long ctCollectionId, long userId, Date startDate) throws PortalException {
        CTCollection ctCollection = this._ctCollectionLocalService.getCTCollection(ctCollectionId);
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(this._getSchedulerJobName(ctCollection), "liferay/ct_collection_scheduled_publish", StorageType.PERSISTED);
        if (schedulerResponse != null) {
            return null;
        }
        this._ctCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)ctCollection, "PUBLISH");
        ctCollection.setStatus(7);
        ctCollection.setStatusByUserId(userId);
        ctCollection = this._ctCollectionLocalService.updateCTCollection(ctCollection);
        this._ctPreferencesLocalService.resetCTPreferences(ctCollectionId);
        Message message = new Message();
        message.put("companyId", (Object)ctCollection.getCompanyId());
        message.put("ctCollectionId", (Object)ctCollectionId);
        message.put("userId", (Object)userId);
        this._schedulerEngineHelper.schedule(this._triggerFactory.createTrigger(this._getSchedulerJobName(ctCollection), "liferay/ct_collection_scheduled_publish", startDate, null, 0, null), StorageType.PERSISTED, String.valueOf(ctCollectionId), "liferay/ct_collection_scheduled_publish", message);
        return null;
    }

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.REQUIRES_NEW);
        builder.setRollbackForClasses(new Class[]{Exception.class});
        _transactionConfig = builder.build();
    }
}

