/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.verify;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={VerifyProcess.class})
public class BookmarksServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(BookmarksServiceVerifyProcess.class);
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Staging _staging;

    protected void doVerify() throws Exception {
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-157670")) {
            this.updateStagedPortletNames();
        }
        this._updateFolderAssets();
        this._verifyTree();
    }

    protected void updateStagedPortletNames() throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property siteProperty = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (typeSettingsUnicodeProperties == null) {
                return;
            }
            String propertyKey = this._staging.getStagedPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
            String propertyValue = typeSettingsUnicodeProperties.getProperty(propertyKey);
            if (Validator.isNull((String)propertyValue)) {
                return;
            }
            typeSettingsUnicodeProperties.remove((Object)propertyKey);
            propertyKey = this._staging.getStagedPortletId("com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet");
            typeSettingsUnicodeProperties.put(propertyKey, propertyValue);
            group.setTypeSettingsProperties(typeSettingsUnicodeProperties);
            this._groupLocalService.updateGroup(group);
        });
        groupActionableDynamicQuery.performActions();
    }

    private void _updateFolderAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List folders = this._bookmarksFolderLocalService.getNoAssetFolders();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + folders.size() + " folders with no asset"));
            }
            for (BookmarksFolder folder : folders) {
                try {
                    this._bookmarksFolderLocalService.updateAsset(folder.getUserId(), folder, null, null, null, null);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for folder ", folder.getFolderId(), ": ", exception.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for folders");
            }
        }
    }

    private void _verifyTree() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> this._bookmarksFolderLocalService.rebuildTree(companyId.longValue()));
        }
    }
}

