/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.search;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.indexer.IndexerWriter;

public class BookmarksFolderBatchReindexer {
    private final IndexerDocumentBuilder _indexerDocumentBuilder;
    private final IndexerWriter<BookmarksFolder> _indexerWriter;

    public BookmarksFolderBatchReindexer(IndexerDocumentBuilder indexerDocumentBuilder, IndexerWriter<BookmarksFolder> indexerWriter) {
        this._indexerDocumentBuilder = indexerDocumentBuilder;
        this._indexerWriter = indexerWriter;
    }

    public void reindex(long folderId, long companyId) {
        BatchIndexingActionable batchIndexingActionable = this._indexerWriter.getBatchIndexingActionable();
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
        });
        batchIndexingActionable.setCompanyId(companyId);
        batchIndexingActionable.setPerformActionMethod(bookmarksFolder -> batchIndexingActionable.addDocuments(new Document[]{this._indexerDocumentBuilder.getDocument((BaseModel)bookmarksFolder)}));
        batchIndexingActionable.performActions();
    }
}

