/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.exportimport.staged.model.repository;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.bookmarks.model.BookmarksFolder"}, service={StagedModelRepository.class})
public class BookmarksFolderStagedModelRepository
implements StagedModelRepository<BookmarksFolder> {
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public BookmarksFolder addStagedModel(PortletDataContext portletDataContext, BookmarksFolder bookmarksFolder) throws PortalException {
        long userId = portletDataContext.getUserId(bookmarksFolder.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)bookmarksFolder);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(bookmarksFolder.getUuid());
        }
        return this._bookmarksFolderLocalService.addFolder(userId, bookmarksFolder.getParentFolderId(), bookmarksFolder.getName(), bookmarksFolder.getDescription(), serviceContext);
    }

    public void deleteStagedModel(BookmarksFolder bookmarksFolder) throws PortalException {
        this._bookmarksFolderLocalService.deleteFolder(bookmarksFolder);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        BookmarksFolder bookmarksFolder = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (bookmarksFolder != null) {
            this.deleteStagedModel(bookmarksFolder);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._bookmarksFolderLocalService.deleteFolders(portletDataContext.getScopeGroupId());
    }

    public BookmarksFolder fetchMissingReference(String uuid, long groupId) {
        return (BookmarksFolder)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public BookmarksFolder fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._bookmarksFolderLocalService.fetchBookmarksFolderByUuidAndGroupId(uuid, groupId);
    }

    public List<BookmarksFolder> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._bookmarksFolderLocalService.getBookmarksFoldersByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._bookmarksFolderLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public BookmarksFolder getStagedModel(long folderId) throws PortalException {
        return this._bookmarksFolderLocalService.getBookmarksFolder(folderId);
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, BookmarksFolder bookmarksFolder) throws PortletDataException {
        BookmarksFolder existingFolder = this.fetchStagedModelByUuidAndGroupId(bookmarksFolder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !this._stagedModelRepositoryHelper.isStagedModelInTrash((StagedModel)existingFolder)) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)BookmarksFolder.class.getName());
        try {
            if (trashHandler.isRestorable(existingFolder.getFolderId())) {
                trashHandler.restoreTrashEntry(portletDataContext.getUserId(bookmarksFolder.getUserUuid()), existingFolder.getFolderId());
            }
        }
        catch (PortalException portalException) {
            throw new PortletDataException((Throwable)portalException);
        }
    }

    public BookmarksFolder saveStagedModel(BookmarksFolder bookmarksFolder) {
        return this._bookmarksFolderLocalService.updateBookmarksFolder(bookmarksFolder);
    }

    public BookmarksFolder updateStagedModel(PortletDataContext portletDataContext, BookmarksFolder bookmarksFolder) throws PortalException {
        long userId = portletDataContext.getUserId(bookmarksFolder.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)bookmarksFolder);
        return this._bookmarksFolderLocalService.updateFolder(userId, bookmarksFolder.getFolderId(), bookmarksFolder.getParentFolderId(), bookmarksFolder.getName(), bookmarksFolder.getDescription(), serviceContext);
    }
}

