/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.exportimport.portlet.preferences.processor;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import jakarta.portlet.PortletPreferences;
import jakarta.portlet.ReadOnlyException;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class BookmarksExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksEntry)")
    private StagedModelRepository<BookmarksEntry> _bookmarksEntryStagedModelRepository;
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private StagedModelRepository<BookmarksFolder> _bookmarksFolderStagedModelRepository;
    @Reference(target="(jakarta.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet)")
    private PortletDataHandler _bookmarksPortletDataHandler;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private PortletLocalService _portletLocalService;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return null;
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        if (!this._exportImportHelper.isExportPortletData(portletDataContext)) {
            return portletPreferences;
        }
        try {
            portletDataContext.addPortletPermissions("com.liferay.bookmarks");
        }
        catch (PortalException portalException) {
            PortletDataException portletDataException = new PortletDataException((Throwable)portalException);
            portletDataException.setPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
            portletDataException.setType(18);
            throw portletDataException;
        }
        try {
            String namespace = this._bookmarksPortletDataHandler.getNamespace();
            String portletId = portletDataContext.getPortletId();
            if (portletDataContext.getBooleanParameter(namespace, "folders")) {
                ExportActionableDynamicQuery folderActionableDynamicQuery = this._bookmarksFolderStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                folderActionableDynamicQuery.setPerformActionMethod(bookmarksFolder -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)bookmarksFolder));
                folderActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "entries")) {
                ExportActionableDynamicQuery entryActionableDynamicQuery = this._bookmarksEntryStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                entryActionableDynamicQuery.setPerformActionMethod(bookmarksEntry -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)bookmarksEntry));
                entryActionableDynamicQuery.performActions();
            }
        }
        catch (PortalException portalException) {
            PortletDataException portletDataException = new PortletDataException((Throwable)portalException);
            portletDataException.setPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
            portletDataException.setType(11);
            throw portletDataException;
        }
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId == 0L) {
            return portletPreferences;
        }
        BookmarksFolder folder = this._bookmarksFolderLocalService.fetchBookmarksFolder(rootFolderId);
        Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletDataContext.getPortletId());
        portletDataContext.addReferenceElement((ClassedModel)portlet, portletDataContext.getExportDataRootElement(), (ClassedModel)folder, "dependency", !portletDataContext.getBooleanParameter(this._bookmarksPortletDataHandler.getNamespace(), "entries"));
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        long rootFolderId;
        try {
            portletDataContext.importPortletPermissions("com.liferay.bookmarks");
        }
        catch (PortalException portalException) {
            PortletDataException portletDataException = new PortletDataException((Throwable)portalException);
            portletDataException.setPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
            portletDataException.setType(20);
            throw portletDataException;
        }
        String namespace = this._bookmarksPortletDataHandler.getNamespace();
        if (portletDataContext.getBooleanParameter(namespace, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(BookmarksFolder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "entries")) {
            Element entriesElement = portletDataContext.getImportDataGroupElement(BookmarksEntry.class);
            List entryElements = entriesElement.elements();
            for (Element entryElement : entryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)entryElement);
            }
        }
        if ((rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null))) <= 0L) {
            return portletPreferences;
        }
        String rootFolderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)BookmarksFolder.class.getName(), (long)rootFolderId);
        BookmarksFolder folder = (BookmarksFolder)portletDataContext.getZipEntryAsObject(rootFolderPath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
        try {
            portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        catch (ReadOnlyException readOnlyException) {
            throw new PortletDataException("Unable to update preference \"rootFolderId\"", (Throwable)readOnlyException);
        }
        return portletPreferences;
    }
}

