/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.service.base;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.bookmarks.service.persistence.BookmarksFolderFinder;
import com.liferay.bookmarks.service.persistence.BookmarksFolderPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class BookmarksFolderLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
BookmarksFolderLocalService,
IdentifiableOSGiService {
    protected BookmarksFolderLocalService bookmarksFolderLocalService;
    @Reference
    protected BookmarksFolderPersistence bookmarksFolderPersistence;
    @Reference
    protected BookmarksFolderFinder bookmarksFolderFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BookmarksFolderLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder addBookmarksFolder(BookmarksFolder bookmarksFolder) {
        bookmarksFolder.setNew(true);
        return (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)bookmarksFolder);
    }

    @Transactional(enabled=false)
    public BookmarksFolder createBookmarksFolder(long folderId) {
        return this.bookmarksFolderPersistence.create(folderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteBookmarksFolder(long folderId) throws PortalException {
        return this.bookmarksFolderPersistence.remove(folderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteBookmarksFolder(BookmarksFolder bookmarksFolder) {
        return (BookmarksFolder)this.bookmarksFolderPersistence.remove((BaseModel)bookmarksFolder);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.bookmarksFolderPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(BookmarksFolder.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.bookmarksFolderPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.bookmarksFolderPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.bookmarksFolderPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.bookmarksFolderPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.bookmarksFolderPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public BookmarksFolder fetchBookmarksFolder(long folderId) {
        return this.bookmarksFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public BookmarksFolder fetchBookmarksFolderByUuidAndGroupId(String uuid, long groupId) {
        return this.bookmarksFolderPersistence.fetchByUUID_G(uuid, groupId);
    }

    public BookmarksFolder getBookmarksFolder(long folderId) throws PortalException {
        return this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.bookmarksFolderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BookmarksFolder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.bookmarksFolderLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(BookmarksFolder.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.bookmarksFolderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BookmarksFolder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add((Criterion)disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)BookmarksFolder.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<BookmarksFolder>(){

            public void performAction(BookmarksFolder bookmarksFolder) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)bookmarksFolder);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)BookmarksFolder.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.bookmarksFolderPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement BookmarksFolderLocalServiceImpl#deleteBookmarksFolder(BookmarksFolder) to avoid orphaned data");
        }
        return this.bookmarksFolderLocalService.deleteBookmarksFolder((BookmarksFolder)persistedModel);
    }

    public BasePersistence<BookmarksFolder> getBasePersistence() {
        return this.bookmarksFolderPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.bookmarksFolderPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<BookmarksFolder> getBookmarksFoldersByUuidAndCompanyId(String uuid, long companyId) {
        return this.bookmarksFolderPersistence.findByUuid_C(uuid, companyId);
    }

    public List<BookmarksFolder> getBookmarksFoldersByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<BookmarksFolder> orderByComparator) {
        return this.bookmarksFolderPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public BookmarksFolder getBookmarksFolderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.bookmarksFolderPersistence.findByUUID_G(uuid, groupId);
    }

    public List<BookmarksFolder> getBookmarksFolders(int start, int end) {
        return this.bookmarksFolderPersistence.findAll(start, end);
    }

    public int getBookmarksFoldersCount() {
        return this.bookmarksFolderPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder updateBookmarksFolder(BookmarksFolder bookmarksFolder) {
        return (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)bookmarksFolder);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BookmarksFolderLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.bookmarksFolderLocalService = (BookmarksFolderLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return BookmarksFolderLocalService.class.getName();
    }

    public CTPersistence<BookmarksFolder> getCTPersistence() {
        return this.bookmarksFolderPersistence;
    }

    public Class<BookmarksFolder> getModelClass() {
        return BookmarksFolder.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<BookmarksFolder>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.bookmarksFolderPersistence);
    }

    protected String getModelClassName() {
        return BookmarksFolder.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.bookmarksFolderPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

