/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.service.base;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.service.persistence.BookmarksEntryPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class BookmarksEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
BookmarksEntryLocalService,
IdentifiableOSGiService {
    protected BookmarksEntryLocalService bookmarksEntryLocalService;
    @Reference
    protected BookmarksEntryPersistence bookmarksEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BookmarksEntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry addBookmarksEntry(BookmarksEntry bookmarksEntry) {
        bookmarksEntry.setNew(true);
        return (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)bookmarksEntry);
    }

    @Transactional(enabled=false)
    public BookmarksEntry createBookmarksEntry(long entryId) {
        return this.bookmarksEntryPersistence.create(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksEntry deleteBookmarksEntry(long entryId) throws PortalException {
        return this.bookmarksEntryPersistence.remove(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksEntry deleteBookmarksEntry(BookmarksEntry bookmarksEntry) {
        return (BookmarksEntry)this.bookmarksEntryPersistence.remove((BaseModel)bookmarksEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.bookmarksEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(BookmarksEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.bookmarksEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.bookmarksEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.bookmarksEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.bookmarksEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.bookmarksEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public BookmarksEntry fetchBookmarksEntry(long entryId) {
        return this.bookmarksEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public BookmarksEntry fetchBookmarksEntryByUuidAndGroupId(String uuid, long groupId) {
        return this.bookmarksEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public BookmarksEntry getBookmarksEntry(long entryId) throws PortalException {
        return this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.bookmarksEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BookmarksEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.bookmarksEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(BookmarksEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.bookmarksEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BookmarksEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add((Criterion)disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)BookmarksEntry.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<BookmarksEntry>(){

            public void performAction(BookmarksEntry bookmarksEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)bookmarksEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)BookmarksEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.bookmarksEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement BookmarksEntryLocalServiceImpl#deleteBookmarksEntry(BookmarksEntry) to avoid orphaned data");
        }
        return this.bookmarksEntryLocalService.deleteBookmarksEntry((BookmarksEntry)persistedModel);
    }

    public BasePersistence<BookmarksEntry> getBasePersistence() {
        return this.bookmarksEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.bookmarksEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<BookmarksEntry> getBookmarksEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.bookmarksEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<BookmarksEntry> getBookmarksEntriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<BookmarksEntry> orderByComparator) {
        return this.bookmarksEntryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public BookmarksEntry getBookmarksEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.bookmarksEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<BookmarksEntry> getBookmarksEntries(int start, int end) {
        return this.bookmarksEntryPersistence.findAll(start, end);
    }

    public int getBookmarksEntriesCount() {
        return this.bookmarksEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry updateBookmarksEntry(BookmarksEntry bookmarksEntry) {
        return (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)bookmarksEntry);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BookmarksEntryLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.bookmarksEntryLocalService = (BookmarksEntryLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return BookmarksEntryLocalService.class.getName();
    }

    public CTPersistence<BookmarksEntry> getCTPersistence() {
        return this.bookmarksEntryPersistence;
    }

    public Class<BookmarksEntry> getModelClass() {
        return BookmarksEntry.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<BookmarksEntry>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.bookmarksEntryPersistence);
    }

    protected String getModelClassName() {
        return BookmarksEntry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.bookmarksEntryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

