/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bookmarks.exception.FolderNameException;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.service.base.BookmarksFolderLocalServiceBaseImpl;
import com.liferay.bookmarks.util.comparator.FolderIdComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.bookmarks.model.BookmarksFolder"}, service={AopService.class})
public class BookmarksFolderLocalServiceImpl
extends BookmarksFolderLocalServiceBaseImpl {
    @Reference
    private BookmarksEntryLocalService _bookmarksEntryLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;

    public BookmarksFolder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        this.validate(name);
        long folderId = this.counterLocalService.increment();
        BookmarksFolder folder = this.bookmarksFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setUserName(user.getFullName());
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        folder = (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)folder);
        this.resourceLocalService.addModelResources((AuditedModel)folder, serviceContext);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public BookmarksFolder deleteFolder(BookmarksFolder folder) throws PortalException {
        return this.bookmarksFolderLocalService.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public BookmarksFolder deleteFolder(BookmarksFolder folder, boolean includeTrashedEntries) throws PortalException {
        List folders = this.bookmarksFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (BookmarksFolder curFolder : folders) {
            if (!includeTrashedEntries && curFolder.isInTrashExplicitly()) continue;
            this.bookmarksFolderLocalService.deleteFolder(curFolder);
        }
        this.bookmarksFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource((AuditedModel)folder, 4);
        this._bookmarksEntryLocalService.deleteEntries(folder.getGroupId(), folder.getFolderId(), includeTrashedEntries);
        this.assetEntryLocalService.deleteEntry(BookmarksFolder.class.getName(), folder.getFolderId());
        this.expandoRowLocalService.deleteRows(folder.getCompanyId(), this.classNameLocalService.getClassNameId(BookmarksFolder.class.getName()), folder.getFolderId());
        this.ratingsStatsLocalService.deleteStats(BookmarksFolder.class.getName(), folder.getFolderId());
        this._subscriptionLocalService.deleteSubscriptions(folder.getCompanyId(), BookmarksFolder.class.getName(), folder.getFolderId());
        if (folder.isInTrashExplicitly()) {
            this._trashEntryLocalService.deleteEntry(BookmarksFolder.class.getName(), folder.getFolderId());
        } else {
            this._trashVersionLocalService.deleteTrashVersion(BookmarksFolder.class.getName(), folder.getFolderId());
        }
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteFolder(long folderId) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        return this.bookmarksFolderLocalService.deleteFolder(folder);
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        return this.bookmarksFolderLocalService.deleteFolder(folder, includeTrashedEntries);
    }

    public void deleteFolders(long groupId) throws PortalException {
        List folders = this.bookmarksFolderPersistence.findByGroupId(groupId);
        for (BookmarksFolder folder : folders) {
            this.bookmarksFolderLocalService.deleteFolder(folder);
        }
    }

    public List<BookmarksFolder> getCompanyFolders(long companyId, int start, int end) {
        return this.bookmarksFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) {
        return this.bookmarksFolderPersistence.countByCompanyId(companyId);
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException {
        return this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
    }

    public List<BookmarksFolder> getFolders(long groupId) {
        return this.bookmarksFolderPersistence.findByGroupId(groupId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId) {
        return this.bookmarksFolderPersistence.findByG_P(groupId, parentFolderId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int start, int end) {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) {
        return this.bookmarksFolderPersistence.findByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId) {
        return this.getFoldersAndEntries(groupId, folderId, -1);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.findF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status, int start, int end) {
        return this.getFoldersAndEntries(groupId, folderId, status, start, end, null);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.bookmarksFolderFinder.findF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndEntriesCount(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.countF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) {
        return this.bookmarksFolderPersistence.countByG_P_S(groupId, parentFolderId, status);
    }

    public List<BookmarksFolder> getNoAssetFolders() {
        return this.bookmarksFolderFinder.findByNoAssets();
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        List folders = this.bookmarksFolderPersistence.findByG_P(groupId, folderId);
        for (BookmarksFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public void mergeFolders(long folderId, long parentFolderId) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (folderId != parentFolderId) {
            this.mergeFolders(folder, parentFolderId);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder moveFolder(long folderId, long parentFolderId) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        if (folder.getParentFolderId() == parentFolderId) {
            return folder;
        }
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder = (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)folder);
        this.rebuildTree(folder.getCompanyId(), folderId, folder.getTreePath(), true);
        return folder;
    }

    public BookmarksFolder moveFolderFromTrash(long userId, long folderId, long parentFolderId) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        if (!folder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (folder.isInTrashExplicitly()) {
            this.restoreFolderFromTrash(userId, folderId);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(BookmarksFolder.class.getName(), folderId);
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, folder, status);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            List foldersAndEntries = this.bookmarksFolderLocalService.getFoldersAndEntries(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(foldersAndEntries);
        }
        return this.bookmarksFolderLocalService.moveFolder(folderId, parentFolderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder moveFolderToTrash(long userId, long folderId) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        if (folder.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = folder.getStatus();
        folder = this.updateStatus(userId, folder, 8);
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), folder.getUuid(), null, oldStatus, null, null);
        List foldersAndEntries = this.bookmarksFolderLocalService.getFoldersAndEntries(folder.getGroupId(), folder.getFolderId());
        this.moveDependentsToTrash(foldersAndEntries, trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), 10007, extraDataJSONObject.toString(), 0L);
        return folder;
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.rebuildTree(companyId, 0L, "/", false);
    }

    public void rebuildTree(long companyId, long parentFolderId, String parentTreePath, boolean reindex) throws PortalException {
        TreePathUtil.rebuildTree((long)companyId, (long)parentFolderId, (String)parentTreePath, (TreeModelTasks)new TreeModelTasksAdapter<BookmarksFolder>(){

            public List<BookmarksFolder> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return BookmarksFolderLocalServiceImpl.this.bookmarksFolderPersistence.findByF_C_P_NotS(previousId, companyId, parentPrimaryKey, 8, -1, size, (OrderByComparator)new FolderIdComparator(true));
            }

            public void rebuildDependentModelsTreePaths(long parentPrimaryKey, String treePath) throws PortalException {
                BookmarksFolderLocalServiceImpl.this._bookmarksEntryLocalService.setTreePaths(parentPrimaryKey, treePath, false);
            }
        });
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder restoreFolderFromTrash(long userId, long folderId) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        if (!folder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(BookmarksFolder.class.getName(), folderId);
        this.updateStatus(userId, folder, trashEntry.getStatus());
        List foldersAndEntries = this.bookmarksFolderLocalService.getFoldersAndEntries(folder.getGroupId(), folder.getFolderId(), 8);
        this.restoreDependentsFromTrash(foldersAndEntries);
        this._trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), 10008, extraDataJSONObject.toString(), 0L);
        return folder;
    }

    public void subscribeFolder(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this._subscriptionLocalService.addSubscription(userId, groupId, BookmarksFolder.class.getName(), folderId);
    }

    public void unsubscribeFolder(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this._subscriptionLocalService.deleteSubscription(userId, BookmarksFolder.class.getName(), folderId);
    }

    public void updateAsset(long userId, BookmarksFolder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), BookmarksFolder.class.getName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, folder.getCreateDate(), null, "text/plain", folder.getName(), folder.getDescription(), null, null, null, 0, 0, priority);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder updateFolder(long userId, long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        this.validate(name);
        long oldParentFolderId = folder.getParentFolderId();
        if (oldParentFolderId != parentFolderId) {
            folder.setParentFolderId(parentFolderId);
            folder.setTreePath(folder.buildTreePath());
        }
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        folder = (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)folder);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        if (oldParentFolderId != parentFolderId) {
            this.rebuildTree(folder.getCompanyId(), folderId, folder.getTreePath(), true);
        }
        return folder;
    }

    public BookmarksFolder updateStatus(long userId, BookmarksFolder folder, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        folder.setStatus(status);
        folder.setStatusByUserId(userId);
        folder.setStatusByUserName(user.getFullName());
        folder.setStatusDate(new Date());
        folder = (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)folder);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), true);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), false);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksFolder.class);
        indexer.reindex((Object)folder);
        return folder;
    }

    protected long getParentFolderId(BookmarksFolder folder, long parentFolderId) {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        BookmarksFolder parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) {
        BookmarksFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(BookmarksFolder fromFolder, long toFolderId) throws PortalException {
        List folders = this.bookmarksFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (BookmarksFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List entries = this.bookmarksEntryPersistence.findByG_F(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (BookmarksEntry entry : entries) {
            entry.setFolderId(toFolderId);
            entry.setTreePath(entry.buildTreePath());
            entry = (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)entry);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksEntry.class);
            indexer.reindex((Object)entry);
        }
        this.bookmarksFolderLocalService.deleteFolder(fromFolder);
    }

    protected void moveDependentsToTrash(List<Object> foldersAndEntries, long trashEntryId) throws PortalException {
        for (Object object : foldersAndEntries) {
            BookmarksFolder folder;
            Indexer indexer;
            int oldStatus;
            if (object instanceof BookmarksEntry) {
                BookmarksEntry entry = (BookmarksEntry)object;
                if (entry.isInTrash()) continue;
                oldStatus = entry.getStatus();
                entry.setStatus(8);
                entry = (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)entry);
                int status = oldStatus;
                if (oldStatus == 1) {
                    status = 2;
                }
                if (oldStatus != 0) {
                    this._trashVersionLocalService.addTrashVersion(trashEntryId, BookmarksEntry.class.getName(), entry.getEntryId(), status, null);
                }
                this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), false);
                indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksEntry.class);
                indexer.reindex((Object)entry);
                continue;
            }
            if (!(object instanceof BookmarksFolder) || (folder = (BookmarksFolder)object).isInTrash()) continue;
            oldStatus = folder.getStatus();
            folder.setStatus(8);
            folder = (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)folder);
            if (oldStatus != 0) {
                this._trashVersionLocalService.addTrashVersion(trashEntryId, BookmarksFolder.class.getName(), folder.getFolderId(), oldStatus, null);
            }
            List<Object> curFoldersAndEntries = this.getFoldersAndEntries(folder.getGroupId(), folder.getFolderId());
            this.moveDependentsToTrash(curFoldersAndEntries, trashEntryId);
            this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), false);
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void restoreDependentsFromTrash(List<Object> foldersAndEntries) throws PortalException {
        for (Object object : foldersAndEntries) {
            BookmarksFolder folder;
            int oldStatus;
            TrashVersion trashVersion;
            if (object instanceof BookmarksEntry) {
                BookmarksEntry entry = (BookmarksEntry)object;
                if (!entry.isInTrashImplicitly()) continue;
                trashVersion = this._trashVersionLocalService.fetchVersion(BookmarksEntry.class.getName(), entry.getEntryId());
                oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                entry.setStatus(oldStatus);
                entry = (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)entry);
                if (trashVersion != null) {
                    this._trashVersionLocalService.deleteTrashVersion(trashVersion);
                }
                if (oldStatus == 0) {
                    this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), true);
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksEntry.class);
                indexer.reindex((Object)entry);
                continue;
            }
            if (!(object instanceof BookmarksFolder) || !(folder = (BookmarksFolder)object).isInTrashImplicitly()) continue;
            trashVersion = this._trashVersionLocalService.fetchVersion(BookmarksFolder.class.getName(), folder.getFolderId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            folder.setStatus(oldStatus);
            folder = (BookmarksFolder)this.bookmarksFolderPersistence.update((BaseModel)folder);
            List<Object> curFoldersAndEntries = this.getFoldersAndEntries(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(curFoldersAndEntries);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), true);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name) || name.contains("\\\\") || name.contains("//")) {
            throw new FolderNameException();
        }
    }
}

