/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bookmarks.configuration.BookmarksGroupServiceOverriddenConfiguration;
import com.liferay.bookmarks.exception.EntryURLException;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.base.BookmarksEntryLocalServiceBaseImpl;
import com.liferay.bookmarks.util.comparator.EntryModifiedDateComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GroupSubscriptionCheckSubscriptionSender;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.bookmarks.model.BookmarksEntry"}, service={AopService.class})
public class BookmarksEntryLocalServiceImpl
extends BookmarksEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(BookmarksEntryLocalServiceImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private ViewCountManager _viewCountManager;

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry addEntry(long userId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        this._validate(url);
        long entryId = this.counterLocalService.increment();
        BookmarksEntry entry = this.bookmarksEntryPersistence.create(entryId);
        entry.setUuid(serviceContext.getUuid());
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setFolderId(folderId);
        entry.setTreePath(entry.buildTreePath());
        entry.setName(name);
        entry.setUrl(url);
        entry.setDescription(description);
        entry.setExpandoBridgeAttributes(serviceContext);
        entry = (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)entry);
        this.resourceLocalService.addModelResources((AuditedModel)entry, serviceContext);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)entry.getName());
        this.socialActivityLocalService.addActivity(userId, groupId, BookmarksEntry.class.getName(), entryId, 1, extraDataJSONObject.toString(), 0L);
        this._notifySubscribers(userId, entry, serviceContext);
        return entry;
    }

    public void deleteEntries(long groupId, long folderId) throws PortalException {
        this.deleteEntries(groupId, folderId, true);
    }

    public void deleteEntries(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        List entries = this.bookmarksEntryPersistence.findByG_F(groupId, folderId);
        for (BookmarksEntry entry : entries) {
            if (!includeTrashedEntries && entry.isInTrashExplicitly()) continue;
            this.bookmarksEntryLocalService.deleteEntry(entry);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public BookmarksEntry deleteEntry(BookmarksEntry entry) throws PortalException {
        this.bookmarksEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource((AuditedModel)entry, 4);
        this.assetEntryLocalService.deleteEntry(BookmarksEntry.class.getName(), entry.getEntryId());
        this.expandoRowLocalService.deleteRows(entry.getCompanyId(), this.classNameLocalService.getClassNameId(BookmarksEntry.class.getName()), entry.getEntryId());
        this.ratingsStatsLocalService.deleteStats(BookmarksEntry.class.getName(), entry.getEntryId());
        this._subscriptionLocalService.deleteSubscriptions(entry.getCompanyId(), BookmarksEntry.class.getName(), entry.getEntryId());
        if (entry.isInTrashExplicitly()) {
            this._trashEntryLocalService.deleteEntry(BookmarksEntry.class.getName(), entry.getEntryId());
        } else {
            this._trashVersionLocalService.deleteTrashVersion(BookmarksEntry.class.getName(), entry.getEntryId());
        }
        this._viewCountManager.deleteViewCount(entry.getCompanyId(), this.classNameLocalService.getClassNameId(BookmarksEntry.class), entry.getEntryId());
        return entry;
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksEntry deleteEntry(long entryId) throws PortalException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        return this.bookmarksEntryLocalService.deleteEntry(entry);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end) {
        return this.getEntries(groupId, folderId, 0, start, end);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int status, int start, int end) {
        return this.getEntries(groupId, folderId, status, start, end, null);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<BookmarksEntry> orderByComparator) {
        return this.bookmarksEntryPersistence.findByG_F_S(groupId, folderId, status, start, end, orderByComparator);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end, OrderByComparator<BookmarksEntry> orderByComparator) {
        return this.getEntries(groupId, folderId, 0, start, end, orderByComparator);
    }

    public int getEntriesCount(long groupId, long folderId) {
        return this.getEntriesCount(groupId, folderId, 0);
    }

    public int getEntriesCount(long groupId, long folderId, int status) {
        return this.bookmarksEntryPersistence.countByG_F_S(groupId, folderId, status);
    }

    public BookmarksEntry getEntry(long entryId) throws PortalException {
        return this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
    }

    public int getFoldersEntriesCount(long groupId, List<Long> folderIds) {
        return this.bookmarksEntryPersistence.countByG_F_S(groupId, ArrayUtil.toArray((Long[])folderIds.toArray(new Long[0])), 0);
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, int start, int end) {
        return this.bookmarksEntryPersistence.findByG_S(groupId, 0, start, end, (OrderByComparator)new EntryModifiedDateComparator());
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, long userId, int start, int end) {
        EntryModifiedDateComparator orderByComparator = new EntryModifiedDateComparator();
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.findByG_S(groupId, 0, start, end, (OrderByComparator)orderByComparator);
        }
        return this.bookmarksEntryPersistence.findByG_U_S(groupId, userId, 0, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupEntriesCount(long groupId) {
        return this.bookmarksEntryPersistence.countByG_S(groupId, 0);
    }

    public int getGroupEntriesCount(long groupId, long userId) {
        if (userId <= 0L) {
            return this.getGroupEntriesCount(groupId);
        }
        return this.bookmarksEntryPersistence.countByG_U_S(groupId, userId, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry moveEntry(long entryId, long parentFolderId) throws PortalException {
        BookmarksEntry entry = this.getBookmarksEntry(entryId);
        entry.setFolderId(parentFolderId);
        entry.setTreePath(entry.buildTreePath());
        return (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)entry);
    }

    public BookmarksEntry moveEntryFromTrash(long userId, long entryId, long parentFolderId) throws PortalException {
        BookmarksEntry entry = this.getBookmarksEntry(entryId);
        if (!entry.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (entry.isInTrashExplicitly()) {
            this.restoreEntryFromTrash(userId, entryId);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(BookmarksEntry.class.getName(), entryId);
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, entry, status);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        return this.bookmarksEntryLocalService.moveEntry(entryId, parentFolderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry moveEntryToTrash(long userId, BookmarksEntry entry) throws PortalException {
        if (entry.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = entry.getStatus();
        entry = this.updateStatus(userId, entry, 8);
        this._trashEntryLocalService.addTrashEntry(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), entry.getUuid(), null, oldStatus, null, null);
        return entry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry moveEntryToTrash(long userId, long entryId) throws PortalException {
        return this.moveEntryToTrash(userId, this.getEntry(entryId));
    }

    @Transactional(enabled=false)
    public BookmarksEntry openEntry(long userId, BookmarksEntry entry) {
        this._viewCountManager.incrementViewCount(entry.getCompanyId(), this.classNameLocalService.getClassNameId(BookmarksEntry.class), entry.getEntryId(), 1);
        return entry;
    }

    public BookmarksEntry openEntry(long userId, long entryId) throws PortalException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        return this.openEntry(userId, entry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry restoreEntryFromTrash(long userId, long entryId) throws PortalException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        if (!entry.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(BookmarksEntry.class.getName(), entryId);
        entry = this.updateStatus(userId, entry, trashEntry.getStatus());
        this._trashEntryLocalService.deleteEntry(BookmarksEntry.class.getName(), entry.getEntryId());
        return entry;
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)BookmarksEntry.class.getName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return indexer.search(searchContext);
    }

    public void setTreePaths(long folderId, String treePath, boolean reindex) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
            Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
        });
        Indexer indexer = IndexerRegistryUtil.getIndexer(BookmarksEntry.class);
        indexableActionableDynamicQuery.setPerformActionMethod(entry -> {
            entry.setTreePath(treePath);
            this.updateBookmarksEntry((BookmarksEntry)entry);
            if (!reindex) {
                return;
            }
            indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(entry)});
        });
        indexableActionableDynamicQuery.performActions();
    }

    public void subscribeEntry(long userId, long entryId) throws PortalException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this._subscriptionLocalService.addSubscription(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entryId);
    }

    public void unsubscribeEntry(long userId, long entryId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, BookmarksEntry.class.getName(), entryId);
    }

    public void updateAsset(long userId, BookmarksEntry entry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, entry.getGroupId(), entry.getCreateDate(), entry.getModifiedDate(), BookmarksEntry.class.getName(), entry.getEntryId(), entry.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, entry.getCreateDate(), null, "text/plain", entry.getName(), entry.getDescription(), null, entry.getUrl(), null, 0, 0, priority);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry updateEntry(long userId, long entryId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        this._validate(url);
        entry.setFolderId(folderId);
        entry.setTreePath(entry.buildTreePath());
        entry.setName(name);
        entry.setUrl(url);
        entry.setDescription(description);
        entry.setExpandoBridgeAttributes(serviceContext);
        entry = (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)entry);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)entry.getName());
        this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entryId, 2, extraDataJSONObject.toString(), 0L);
        this._notifySubscribers(userId, entry, serviceContext);
        return entry;
    }

    public BookmarksEntry updateStatus(long userId, BookmarksEntry entry, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        entry.setStatus(status);
        entry.setStatusByUserId(userId);
        entry.setStatusByUserName(user.getScreenName());
        entry.setStatusDate(new Date());
        entry = (BookmarksEntry)this.bookmarksEntryPersistence.update((BaseModel)entry);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)entry.getName());
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), true);
            this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), 10008, extraDataJSONObject.toString(), 0L);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), false);
            this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), 10007, extraDataJSONObject.toString(), 0L);
        }
        return entry;
    }

    private String _getBookmarksEntryURL(BookmarksEntry entry, ServiceContext serviceContext) throws PortalException {
        String layoutURL = this._portal.getLayoutFullURL(entry.getGroupId(), "com_liferay_bookmarks_web_portlet_BookmarksPortlet");
        if (Validator.isNotNull((String)layoutURL)) {
            return StringBundler.concat((Object[])new Object[]{layoutURL, "/-/", "bookmarks/folder/", entry.getFolderId()});
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return StringBundler.concat((Object[])new Object[]{serviceContext.getLayoutFullURL(), "/-/", "bookmarks/folder/", entry.getFolderId()});
        }
        Group group = this.groupLocalService.fetchGroup(entry.getGroupId());
        PortletURL portletURL = this._portal.getControlPanelPortletURL(httpServletRequest, group, "com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", 0L, 0L, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/bookmarks/view");
        portletURL.setParameter("folderId", String.valueOf(entry.getFolderId()));
        return portletURL.toString();
    }

    private void _notifySubscribers(long userId, BookmarksEntry entry, ServiceContext serviceContext) throws PortalException {
        if (!entry.isApproved() || Validator.isNull((String)serviceContext.getLayoutFullURL())) {
            return;
        }
        BookmarksGroupServiceOverriddenConfiguration bookmarksGroupServiceOverriddenConfiguration = (BookmarksGroupServiceOverriddenConfiguration)this._configurationProvider.getConfiguration(BookmarksGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(entry.getGroupId(), "com.liferay.bookmarks"));
        if (serviceContext.isCommandAdd() && !bookmarksGroupServiceOverriddenConfiguration.emailEntryAddedEnabled() || serviceContext.isCommandUpdate() && !bookmarksGroupServiceOverriddenConfiguration.emailEntryUpdatedEnabled()) {
            return;
        }
        String statusByUserName = "";
        try {
            User user = this.userLocalService.getUserById(serviceContext.getGuestOrUserId());
            statusByUserName = user.getFullName();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        String entryTitle = entry.getName();
        String entryURL = this._getBookmarksEntryURL(entry, serviceContext);
        String fromName = bookmarksGroupServiceOverriddenConfiguration.emailFromName();
        String fromAddress = bookmarksGroupServiceOverriddenConfiguration.emailFromAddress();
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (serviceContext.isCommandUpdate()) {
            subjectLocalizedValuesMap = bookmarksGroupServiceOverriddenConfiguration.emailEntryUpdatedSubject();
            bodyLocalizedValuesMap = bookmarksGroupServiceOverriddenConfiguration.emailEntryUpdatedBody();
        } else {
            subjectLocalizedValuesMap = bookmarksGroupServiceOverriddenConfiguration.emailEntryAddedSubject();
            bodyLocalizedValuesMap = bookmarksGroupServiceOverriddenConfiguration.emailEntryAddedBody();
        }
        GroupSubscriptionCheckSubscriptionSender subscriptionSender = new GroupSubscriptionCheckSubscriptionSender("com.liferay.bookmarks");
        subscriptionSender.setClassName(entry.getModelClassName());
        subscriptionSender.setClassPK(entry.getEntryId());
        subscriptionSender.setCompanyId(entry.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$BOOKMARKS_ENTRY_STATUS_BY_USER_NAME$]", statusByUserName, "[$BOOKMARKS_ENTRY_URL$]", entryURL});
        subscriptionSender.setContextCreatorUserPrefix("BOOKMARKS_ENTRY");
        subscriptionSender.setCreatorUserId(entry.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(entryURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        if (bodyLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        }
        if (subjectLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        }
        subscriptionSender.setMailId("bookmarks_entry", new Object[]{entry.getEntryId()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(entry.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        BookmarksFolder folder = entry.getFolder();
        if (folder != null) {
            subscriptionSender.addPersistedSubscribers(BookmarksFolder.class.getName(), folder.getFolderId());
            for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                subscriptionSender.addPersistedSubscribers(BookmarksFolder.class.getName(), ancestorFolderId.longValue());
            }
        }
        subscriptionSender.addPersistedSubscribers(BookmarksFolder.class.getName(), entry.getGroupId());
        subscriptionSender.addPersistedSubscribers(BookmarksEntry.class.getName(), entry.getEntryId());
        subscriptionSender.flushNotificationsAsync();
    }

    private void _validate(String url) throws PortalException {
        if (!Validator.isUrl((String)url)) {
            throw new EntryURLException();
        }
    }
}

