/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.service.impl;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.base.BookmarksFolderServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=bookmarks", "json.web.service.context.path=BookmarksFolder"}, service={AopService.class})
public class BookmarksFolderServiceImpl
extends BookmarksFolderServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private volatile ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;

    public BookmarksFolder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(this._bookmarksFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)serviceContext.getScopeGroupId(), (long)parentFolderId, (String)"ADD_FOLDER");
        return this.bookmarksFolderLocalService.addFolder(this.getUserId(), parentFolderId, name, description, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "DELETE");
        this.bookmarksFolderLocalService.deleteFolder(folderId);
    }

    public void deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "DELETE");
        this.bookmarksFolderLocalService.deleteFolder(folderId, includeTrashedEntries);
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)folder, "VIEW");
        return folder;
    }

    public List<Long> getFolderIds(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionHelper.check(this._bookmarksFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW");
        List<Long> folderIds = this.getSubfolderIds(groupId, folderId, true);
        folderIds.add(0, folderId);
        return folderIds;
    }

    public List<BookmarksFolder> getFolders(long groupId) {
        return this.bookmarksFolderPersistence.filterFindByGroupId(groupId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId) {
        return this.bookmarksFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, 0);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int start, int end) {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) {
        if (status == -1) {
            return this.bookmarksFolderPersistence.filterFindByG_P(groupId, parentFolderId, start, end);
        }
        return this.bookmarksFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId) {
        return this.getFoldersAndEntries(groupId, folderId, -1);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.filterFindBF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.bookmarksFolderFinder.filterFindBF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndEntriesCount(long groupId, long folderId) {
        return this.getFoldersAndEntriesCount(groupId, folderId, -1);
    }

    public int getFoldersAndEntriesCount(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.filterCountF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) {
        if (status == -1) {
            return this.bookmarksFolderPersistence.filterCountByG_P_NotS(groupId, parentFolderId, 8);
        }
        return this.bookmarksFolderPersistence.filterCountByG_P_S(groupId, parentFolderId, status);
    }

    @Deprecated
    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        this.getSubfolderIds(folderIds, groupId, folderId, true);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId, boolean recurse) {
        List folders = this.bookmarksFolderPersistence.filterFindByG_P_S(groupId, folderId, 0);
        for (BookmarksFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            if (!recurse) continue;
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId(), recurse);
        }
    }

    public List<Long> getSubfolderIds(long groupId, long folderId, boolean recurse) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        this.getSubfolderIds(folderIds, groupId, folderId, recurse);
        return folderIds;
    }

    public void mergeFolders(long folderId, long parentFolderId) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "UPDATE");
        this.bookmarksFolderLocalService.mergeFolders(folderId, parentFolderId);
    }

    public BookmarksFolder moveFolder(long folderId, long parentFolderId) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "UPDATE");
        return this.bookmarksFolderLocalService.moveFolder(folderId, parentFolderId);
    }

    public BookmarksFolder moveFolderFromTrash(long folderId, long parentFolderId) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "UPDATE");
        return this.bookmarksFolderLocalService.moveFolderFromTrash(this.getUserId(), folderId, parentFolderId);
    }

    public BookmarksFolder moveFolderToTrash(long folderId) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "DELETE");
        return this.bookmarksFolderLocalService.moveFolderToTrash(this.getUserId(), folderId);
    }

    public void restoreFolderFromTrash(long folderId) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "UPDATE");
        this.bookmarksFolderLocalService.restoreFolderFromTrash(this.getUserId(), folderId);
    }

    public void subscribeFolder(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionHelper.check(this._bookmarksFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.bookmarksFolderLocalService.subscribeFolder(this.getUserId(), groupId, folderId);
    }

    public void unsubscribeFolder(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionHelper.check(this._bookmarksFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.bookmarksFolderLocalService.unsubscribeFolder(this.getUserId(), groupId, folderId);
    }

    @Deprecated
    public BookmarksFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "UPDATE");
        return this.bookmarksFolderLocalService.updateFolder(this.getUserId(), folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext);
    }

    public BookmarksFolder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this._bookmarksFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.bookmarksFolderLocalService.getFolder(folderId), "UPDATE");
        return this.bookmarksFolderLocalService.updateFolder(this.getUserId(), folderId, parentFolderId, name, description, serviceContext);
    }
}

