/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.security.permission.resource;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.model.BookmarksFolderModel;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class BookmarksFolderModelResourcePermissionRegistrar {
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference(target="(resource.name=com.liferay.bookmarks)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;

    @Activate
    public void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", BookmarksFolder.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(BookmarksFolder.class, BookmarksFolderModel::getFolderId, arg_0 -> ((BookmarksFolderLocalService)this._bookmarksFolderLocalService).getFolder(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_bookmarks_web_portlet_BookmarksPortlet", BookmarksFolderModel::getFolderId));
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new DynamicInheritancePermissionLogic(modelResourcePermission, this._getFetchParentFunction(), true));
            }
        }, actionId -> {
            if ("ADD_FOLDER".equals(actionId)) {
                return "ADD_SUBFOLDER";
            }
            return actionId;
        }), (Dictionary)properties);
    }

    @Deactivate
    public void deactivate() {
        this._serviceRegistration.unregister();
    }

    private UnsafeFunction<BookmarksFolder, BookmarksFolder, PortalException> _getFetchParentFunction() {
        return folder -> {
            long folderId = folder.getParentFolderId();
            if (0L == folderId) {
                return null;
            }
            if (folder.isInTrash()) {
                return this._bookmarksFolderLocalService.fetchBookmarksFolder(folderId);
            }
            return this._bookmarksFolderLocalService.getFolder(folderId);
        };
    }
}

