/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.upgrade.v3_1_1;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class BlogsFriendlyURLFormatUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final FriendlyURLEntryLocalService _friendlyURLEntryLocalService;

    public BlogsFriendlyURLFormatUpgradeProcess(ClassNameLocalService classNameLocalService, FriendlyURLEntryLocalService friendlyURLEntryLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._friendlyURLEntryLocalService = friendlyURLEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select distinct ctCollectionId, friendlyURLEntryId, ", "languageId, urlTitle, groupId, classPK from ", "FriendlyURLEntryLocalization where urlTitle like '%/' ", "and classNameId = ?"}));){
            long classNameId = this._classNameLocalService.getClassNameId(BlogsEntry.class);
            preparedStatement.setLong(1, classNameId);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long classPK = resultSet.getLong("classPK");
                long groupId = resultSet.getLong("groupId");
                String languageId = resultSet.getString("languageId");
                String urlTitle = resultSet.getString("urlTitle");
                while (urlTitle.endsWith("/")) {
                    urlTitle = urlTitle.substring(0, urlTitle.length() - 1);
                }
                urlTitle = this._friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, classNameId, classPK, urlTitle, languageId);
                this._updateURLTitle(classPK, resultSet.getLong("ctCollectionId"), groupId, urlTitle);
                this._updateFriendlyURLEntry(resultSet.getLong("friendlyURLEntryId"), languageId, urlTitle);
            }
        }
    }

    private void _updateFriendlyURLEntry(long friendlyURLEntryId, String languageId, String urlTitle) throws PortalException {
        FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(friendlyURLEntryId);
        this._friendlyURLEntryLocalService.updateFriendlyURLEntryLocalization(friendlyURLEntry, languageId, urlTitle);
    }

    private void _updateURLTitle(long classPK, long ctCollectionId, long groupId, String urlTitle) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update BlogsEntry set urlTitle = ? where ctCollectionId = ? and entryId = ? and groupId = ?");){
            preparedStatement.setString(1, urlTitle);
            preparedStatement.setLong(2, ctCollectionId);
            preparedStatement.setLong(3, classPK);
            preparedStatement.setLong(4, groupId);
            preparedStatement.executeUpdate();
        }
    }
}

