/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.service.impl;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.model.BlogsEntryTable;
import com.liferay.blogs.model.BlogsStatsUser;
import com.liferay.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.blogs.service.base.BlogsStatsUserLocalServiceBaseImpl;
import com.liferay.blogs.service.persistence.BlogsEntryPersistence;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Alias;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Users_OrgsTable;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.ratings.kernel.model.RatingsEntryTable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.UnaryOperator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.blogs.model.BlogsStatsUser"}, service={AopService.class})
public class BlogsStatsUserLocalServiceImpl
extends BlogsStatsUserLocalServiceBaseImpl {
    @Reference
    private BlogsEntryPersistence _blogsEntryPersistence;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private final Alias<Long> _companyIdAlias;
    private final Expression<Long> _entryCountExpression;
    private final Alias<Long> _groupIdAlias;
    private final Expression<Long> _groupIdExpression;
    private final Expression<Date> _lastPostDateExpression;
    private final Alias<Long> _userIdAlias;

    public BlogsStatsUserLocalServiceImpl() {
        this._companyIdAlias = BlogsEntryTable.INSTANCE.companyId.as("blogsEntryCompanyId");
        this._entryCountExpression = DSLFunctionFactoryUtil.countDistinct((Expression)BlogsEntryTable.INSTANCE.entryId).as("entryCount");
        this._groupIdAlias = BlogsEntryTable.INSTANCE.groupId.as("blogsEntryGroupId");
        this._groupIdExpression = DSLFunctionFactoryUtil.max((Expression)BlogsEntryTable.INSTANCE.groupId).as("groupId");
        this._lastPostDateExpression = DSLFunctionFactoryUtil.max((Expression)BlogsEntryTable.INSTANCE.modifiedDate).as("lastPostDate");
        this._userIdAlias = BlogsEntryTable.INSTANCE.userId.as("blogsEntryUserId");
    }

    public List<BlogsStatsUser> getGroupsStatsUsers(long companyId, long groupId, int start, int end) {
        Predicate predicate = this._companyIdAlias.eq((Object)companyId);
        return this._getBlogsStatsUsers(UnaryOperator.identity(), predicate.and((Expression)this._groupIdAlias.eq((Object)groupId)), this._entryCountExpression.descending(), start, end);
    }

    public List<BlogsStatsUser> getGroupStatsUsers(long groupId, int start, int end) {
        Predicate predicate = this._groupIdAlias.eq((Object)groupId);
        return this._getBlogsStatsUsers(UnaryOperator.identity(), predicate.and((Expression)this._entryCountExpression.neq((Object)0L)), this._lastPostDateExpression.descending(), start, end);
    }

    public List<BlogsStatsUser> getOrganizationStatsUsers(long organizationId, int start, int end) {
        return this._getBlogsStatsUsers(joinStep -> joinStep.innerJoinON((Table)Users_OrgsTable.INSTANCE, Users_OrgsTable.INSTANCE.userId.eq((Expression)BlogsEntryTable.INSTANCE.userId).and((Expression)Users_OrgsTable.INSTANCE.organizationId.eq((Object)organizationId))), null, this._lastPostDateExpression.descending(), start, end);
    }

    public BlogsStatsUser getStatsUser(long groupId, long userId) throws PortalException {
        Predicate predicate = this._groupIdAlias.eq((Object)groupId);
        List<BlogsStatsUser> blogsStatsUsers = this._getBlogsStatsUsers(UnaryOperator.identity(), predicate.and((Expression)this._userIdAlias.eq((Object)userId)), this._groupIdExpression.descending(), 0, 1);
        if (blogsStatsUsers.isEmpty()) {
            return new BlogsStatsUserImpl(0L, groupId, null, 0L, 0.0, 0.0, userId);
        }
        return blogsStatsUsers.get(0);
    }

    private List<BlogsStatsUser> _getBlogsStatsUsers(UnaryOperator<JoinStep> unaryOperator, Predicate predicate, OrderByExpression orderByExpression, int start, int end) {
        GroupByStep orderByStep;
        JoinStep joinStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{this._entryCountExpression, this._groupIdAlias, this._lastPostDateExpression, DSLFunctionFactoryUtil.countDistinct((Expression)RatingsEntryTable.INSTANCE.entryId).as("ratingsTotalEntries"), DSLFunctionFactoryUtil.avg((Expression)RatingsEntryTable.INSTANCE.score).as("ratingsAverageScore"), DSLFunctionFactoryUtil.sum((Expression)RatingsEntryTable.INSTANCE.score).as("ratingsTotalScore"), this._userIdAlias, this._companyIdAlias, this._groupIdExpression}).from((Table)BlogsEntryTable.INSTANCE);
        joinStep = (JoinStep)unaryOperator.apply(joinStep);
        Table innerTable = joinStep.leftJoinOn((Table)RatingsEntryTable.INSTANCE, RatingsEntryTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(BlogsEntry.class.getName())).and((Expression)RatingsEntryTable.INSTANCE.classPK.eq((Expression)BlogsEntryTable.INSTANCE.entryId))).groupBy(new Expression[]{BlogsEntryTable.INSTANCE.groupId, BlogsEntryTable.INSTANCE.userId, BlogsEntryTable.INSTANCE.companyId}).as("innerTable");
        GroupByStep limitStep = orderByStep = DSLQueryFactoryUtil.select().from(innerTable).where(predicate);
        if (orderByExpression != null) {
            limitStep = orderByStep.orderBy(new OrderByExpression[]{orderByExpression});
        }
        List results = (List)this._blogsEntryPersistence.dslQuery(limitStep.limit(start, end));
        ArrayList<BlogsStatsUser> blogsStatsUsers = new ArrayList<BlogsStatsUser>(results.size());
        for (Object[] columns : results) {
            blogsStatsUsers.add(new BlogsStatsUserImpl(GetterUtil.getLong((Object)columns[0]), GetterUtil.getLong((Object)columns[1]), (Date)columns[2], GetterUtil.getLong((Object)columns[3]), GetterUtil.getDouble((Object)columns[4]), GetterUtil.getDouble((Object)columns[5]), GetterUtil.getLong((Object)columns[6])));
        }
        return blogsStatsUsers;
    }
}

