/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.security.permission.resource;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelResourcePermissionFactory.ModelResourcePermissionConfigurator.class})
public class BlogsDLFileEntryModelResourcePermissionConfigurator
implements ModelResourcePermissionFactory.ModelResourcePermissionConfigurator<DLFileEntry> {
    private static final Set<String> _delegableActionIds = SetUtil.fromArray((Object[])new String[]{"DELETE", "UPDATE"});
    @Reference(target="(resource.name=com.liferay.blogs)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private RepositoryLocalService _repositoryLocalService;

    public void configureModelResourcePermissionLogics(ModelResourcePermission<DLFileEntry> modelResourcePermission, Consumer<ModelResourcePermissionLogic<DLFileEntry>> consumer) {
        consumer.accept((ModelResourcePermissionLogic<DLFileEntry>)((ModelResourcePermissionLogic)(permissionChecker, name, dlFileEntry, actionId) -> {
            if (!_delegableActionIds.contains(actionId)) {
                return null;
            }
            Repository repository = this._repositoryLocalService.fetchRepository(dlFileEntry.getRepositoryId());
            if (repository == null || !Objects.equals(repository.getPortletId(), "com.liferay.blogs")) {
                return null;
            }
            return this._portletResourcePermission.contains(permissionChecker, dlFileEntry.getGroupId(), "ADD_ENTRY");
        }));
    }
}

