/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.model.listener;

import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserGroupModelListener
extends BaseModelListener<UserGroup> {
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterRemoveAssociation(Object userGroupId, String associationClassName, Object associationClassPK) throws ModelListenerException {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this._unsubscribeUserFromUserGroupGroups((Long)associationClassPK, (Long)userGroupId);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
        try {
            if (associationClassName.equals(Group.class.getName())) {
                this._unsubscribeUserGroupUsersFromGroup((Long)associationClassPK, (Long)userGroupId);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _unsubscribeUserFromUserGroupGroups(long userId, long userGroupId) throws PortalException {
        List groupIds = ListUtil.toList((List)this._groupLocalService.getUserGroups(userId, true), GroupModel::getGroupId);
        for (long groupId : this._userGroupLocalService.getGroupPrimaryKeys(userGroupId)) {
            if (groupIds.contains(groupId)) continue;
            this._blogsEntryLocalService.unsubscribe(userId, groupId);
        }
    }

    private void _unsubscribeUserGroupUsersFromGroup(long groupId, long userGroupId) throws PortalException {
        Set userGroupUserIds = SetUtil.fromArray((long[])this._userGroupLocalService.getUserPrimaryKeys(userGroupId));
        userGroupUserIds.removeAll(SetUtil.fromArray((long[])this._groupLocalService.getUserPrimaryKeys(groupId)));
        Group group = this._groupLocalService.getGroup(groupId);
        if (group.getOrganizationId() > 0L) {
            userGroupUserIds.removeAll(SetUtil.fromArray((long[])this._userLocalService.getOrganizationUserIds(group.getOrganizationId())));
        }
        long[] organizationIds = this._groupLocalService.getOrganizationPrimaryKeys(groupId);
        for (long organizationId : organizationIds) {
            userGroupUserIds.removeAll(SetUtil.fromArray((long[])this._userLocalService.getOrganizationUserIds(organizationId)));
        }
        for (long userGroupPK : this._groupLocalService.getUserGroupPrimaryKeys(groupId)) {
            if (userGroupPK == userGroupId) continue;
            userGroupUserIds.removeAll(SetUtil.fromArray((long[])this._userGroupLocalService.getUserPrimaryKeys(userGroupPK)));
        }
        Object object = userGroupUserIds.iterator();
        while (object.hasNext()) {
            long userId = (Long)object.next();
            this._blogsEntryLocalService.unsubscribe(userId, groupId);
        }
    }
}

