/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.search.spi.model.index.contributor;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.IndexerWriterMode;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;

public class BlogsEntryModelIndexerWriterContributor
implements ModelIndexerWriterContributor<BlogsEntry> {
    private final BlogsEntryLocalService _blogsEntryLocalService;
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;

    public BlogsEntryModelIndexerWriterContributor(BlogsEntryLocalService blogsEntryLocalService, DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory) {
        this._blogsEntryLocalService = blogsEntryLocalService;
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setPerformActionMethod(blogsEntry -> batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)blogsEntry)}));
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._blogsEntryLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(BlogsEntry blogsEntry) {
        return blogsEntry.getCompanyId();
    }

    public IndexerWriterMode getIndexerWriterMode(BlogsEntry blogsEntry) {
        if (blogsEntry.isApproved() || blogsEntry.isDraft() || blogsEntry.isInTrash() || blogsEntry.isPending() || blogsEntry.isScheduled()) {
            return IndexerWriterMode.UPDATE;
        }
        if (!blogsEntry.isApproved() && !blogsEntry.isInTrash()) {
            return IndexerWriterMode.SKIP;
        }
        return IndexerWriterMode.DELETE;
    }
}

