/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.upgrade.v1_1_2;

import com.liferay.blogs.internal.upgrade.v1_1_1.util.BlogsEntryTable;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeBlogsImages
extends UpgradeProcess {
    private final ImageLocalService _imageLocalService;
    private final PortletFileRepository _portletFileRepository;

    public UpgradeBlogsImages(ImageLocalService imageLocalService, PortletFileRepository portletFileRepository) {
        this._imageLocalService = imageLocalService;
        this._portletFileRepository = portletFileRepository;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasColumnType("BlogsEntry", "smallImageId", "LONG null")) {
            this.alter(BlogsEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "smallImageId", "LONG null")});
        }
        try (PreparedStatement ps1 = this.connection.prepareStatement(SQLTransformer.transform((String)"select entryId, groupId, companyId, userId, smallImageId from BlogsEntry where smallImage = [$TRUE$] and smallImageId != 0"));
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update BlogsEntry set smallImageFileEntryId = ?, smallImageId = 0 where entryId = ?"));
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long smallImageId = rs.getLong("smallImageId");
                Image smallImage = this._imageLocalService.fetchImage(smallImageId);
                if (smallImage == null) continue;
                long entryId = rs.getLong("entryId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = PortalUtil.getValidUserId((long)companyId, (long)rs.getLong("userId"));
                byte[] bytes = smallImage.getTextObj();
                String fileName = StringBundler.concat((Object[])new Object[]{smallImage.getImageId(), ".", smallImage.getType()});
                String mimeType = this._getContentType(bytes);
                Folder smallImagefolder = this._addFolder(userId, groupId, "Small Image");
                FileEntry processedImageFileEntry = this._portletFileRepository.addPortletFileEntry(groupId, userId, BlogsEntry.class.getName(), entryId, "com.liferay.blogs", smallImagefolder.getFolderId(), bytes, fileName, mimeType, true);
                Folder blogsImagefolder = this._addFolder(userId, groupId, "com.liferay.blogs");
                this._portletFileRepository.addPortletFileEntry(groupId, userId, null, 0L, "com.liferay.blogs", blogsImagefolder.getFolderId(), bytes, fileName, mimeType, true);
                ps2.setLong(1, processedImageFileEntry.getFileEntryId());
                ps2.setLong(2, entryId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    private Folder _addFolder(long userId, long groupId, String folderName) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = this._portletFileRepository.addPortletRepository(groupId, "com.liferay.blogs", serviceContext);
        return this._portletFileRepository.addPortletFolder(userId, repository.getRepositoryId(), 0L, folderName, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getContentType(byte[] bytes) throws IOException {
        File tempFile = FileUtil.createTempFile((byte[])bytes);
        try {
            String string = MimeTypesUtil.getContentType((File)tempFile);
            return string;
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }
}

