/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import jakarta.annotation.ManagedBean;
import jakarta.annotation.Priority;
import jakarta.mvc.engine.ViewEngine;
import jakarta.mvc.engine.ViewEngineContext;
import jakarta.mvc.engine.ViewEngineException;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletRequestDispatcher;
import jakarta.portlet.PortletResponse;
import jakarta.ws.rs.core.Configuration;

@ManagedBean
@Priority(value=1000)
public class ViewEngineJspImpl
implements ViewEngine {
    private final Configuration _configuration;
    private final PortletContext _portletContext;

    public ViewEngineJspImpl(Configuration configuration, PortletContext portletContext) {
        this._configuration = configuration;
        this._portletContext = portletContext;
    }

    public void processView(ViewEngineContext viewEngineContext) throws ViewEngineException {
        String view = viewEngineContext.getView();
        String viewFolder = (String)this._configuration.getProperty("jakarta.mvc.engine.ViewEngine.viewFolder");
        if (viewFolder == null) {
            viewFolder = "/WEB-INF/views/";
        }
        String viewPath = viewFolder.concat(view);
        PortletRequestDispatcher requestDispatcher = this._portletContext.getRequestDispatcher(viewPath);
        try {
            requestDispatcher.include((PortletRequest)viewEngineContext.getRequest(PortletRequest.class), (PortletResponse)viewEngineContext.getResponse(PortletResponse.class));
        }
        catch (Exception exception) {
            throw new ViewEngineException((Throwable)exception);
        }
    }

    public boolean supports(String view) {
        return view != null && (view.endsWith(".jsp") || view.endsWith(".jspx"));
    }
}

