/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.spring.extension.internal.mvc.DescendingPriorityComparator;
import com.liferay.bean.portlet.spring.extension.internal.mvc.MVCContextImpl;
import jakarta.annotation.PostConstruct;
import jakarta.mvc.MvcContext;
import jakarta.mvc.locale.LocaleResolver;
import jakarta.mvc.security.Encoders;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.ws.rs.core.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

@org.springframework.context.annotation.Configuration
public class MVCContextProducer
implements ApplicationContextAware {
    private ApplicationContext _applicationContext;
    @Autowired
    private Configuration _configuration;
    @Autowired
    private Encoders _encoders;
    private List<LocaleResolver> _localeResolvers;
    @Autowired
    private PortletContext _portletContext;
    @Autowired
    private PortletRequest _portletRequest;

    @Bean(value={"mvc"})
    @Scope(value="portletRequest")
    public MvcContext getMvcContext() {
        return new MVCContextImpl(this._configuration, this._encoders, this._localeResolvers, this._portletContext, this._portletRequest);
    }

    @PostConstruct
    public void postConstruct() {
        Map beansOfType = this._applicationContext.getBeansOfType(LocaleResolver.class);
        this._localeResolvers = new ArrayList(beansOfType.values());
        Collections.sort(this._localeResolvers, new LocaleResolverPriorityComparator());
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private static class LocaleResolverPriorityComparator
    extends DescendingPriorityComparator<LocaleResolver> {
        private LocaleResolverPriorityComparator() {
            super(1000);
        }
    }
}

