/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.spring.extension.internal.mvc.MutableBindingResult;
import com.liferay.petra.function.transform.TransformUtil;
import jakarta.annotation.ManagedBean;
import jakarta.mvc.binding.BindingError;
import jakarta.mvc.binding.ParamError;
import jakarta.mvc.binding.ValidationError;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@ManagedBean
@Scope(proxyMode=ScopedProxyMode.INTERFACES, value="portletRedirect")
public class BindingResultImpl
implements MutableBindingResult,
Serializable {
    private static final long serialVersionUID = 2217732469752342741L;
    private final Set<BindingError> _bindingErrors = new LinkedHashSet<BindingError>();
    private boolean _consulted;
    private final Set<ValidationError> _validationErrors = new LinkedHashSet<ValidationError>();

    @Override
    public void addBindingError(BindingError bindingError) {
        this._bindingErrors.add(bindingError);
    }

    @Override
    public void addValidationError(ValidationError validationError) {
        this._validationErrors.add(validationError);
    }

    public Set<ParamError> getAllErrors() {
        this._consulted = true;
        LinkedHashSet<ParamError> allParamErrors = new LinkedHashSet<ParamError>();
        allParamErrors.addAll(this._bindingErrors);
        allParamErrors.addAll(this._validationErrors);
        return allParamErrors;
    }

    public List<String> getAllMessages() {
        this._consulted = true;
        List allMessages = TransformUtil.transform(this._bindingErrors, bindingError -> bindingError.getMessage());
        allMessages.addAll(TransformUtil.transform(this._validationErrors, validationError -> validationError.getMessage()));
        return allMessages;
    }

    public Set<ParamError> getErrors(String paramName) {
        this._consulted = true;
        LinkedHashSet<ParamError> paramErrors = new LinkedHashSet<ParamError>();
        for (BindingError bindingError : this._bindingErrors) {
            if (!Objects.equals(bindingError.getParamName(), paramName)) continue;
            paramErrors.add((ParamError)bindingError);
        }
        for (ValidationError validationError : this._validationErrors) {
            if (!Objects.equals(validationError.getParamName(), paramName)) continue;
            paramErrors.add((ParamError)validationError);
        }
        return paramErrors;
    }

    @Override
    public boolean isConsulted() {
        return this._consulted;
    }

    public boolean isFailed() {
        this._consulted = true;
        return !this._bindingErrors.isEmpty() || !this._validationErrors.isEmpty();
    }
}

