/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.scope;

import com.liferay.bean.portlet.spring.extension.internal.scope.BaseScope;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBean;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBeanManager;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBeanManagerThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import jakarta.portlet.annotations.PortletRequestScoped;

public class SpringPortletRequestScope
extends BaseScope {
    private static final Log _log = LogFactoryUtil.getLog(SpringPortletRequestScope.class);

    @Override
    public String getScopeName() {
        return PortletRequestScoped.class.getSimpleName();
    }

    @Override
    protected SpringScopedBean getSpringScopedBean(String name) {
        SpringScopedBeanManager springScopedBeanManager = SpringScopedBeanManagerThreadLocal.getCurrentScopedBeanManager();
        if (springScopedBeanManager == null) {
            _log.error((Object)("Attempted to get a @PortletRequestScoped bean named " + name + " outside the scope of a portlet request"));
            return null;
        }
        return springScopedBeanManager.getPortletRequestScopedBean(name);
    }

    @Override
    protected void setSpringScopedBean(String name, SpringScopedBean springScopedBean) {
        SpringScopedBeanManager springScopedBeanManager = SpringScopedBeanManagerThreadLocal.getCurrentScopedBeanManager();
        springScopedBeanManager.setPortletRequestScopedBean(name, springScopedBean);
    }
}

