/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.spring.extension.internal.mvc.DescendingPriorityComparator;
import com.liferay.bean.portlet.spring.extension.internal.mvc.ParamConverterProviders;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class ParamConverterProvidersProducer
implements ApplicationContextAware {
    private ApplicationContext _applicationContext;
    private List<ParamConverterProvider> _paramConverterProviders;

    @Bean
    @ParamConverterProviders
    @Scope(value="prototype")
    public List<ParamConverterProvider> getParamConverterProviders() {
        return this._paramConverterProviders;
    }

    @PostConstruct
    public void postConstruct() {
        Map paramConverterProviders = this._applicationContext.getBeansOfType(ParamConverterProvider.class);
        this._paramConverterProviders = new ArrayList(paramConverterProviders.values());
        Collections.sort(this._paramConverterProviders, new ParamConverterProviderPriorityComparator());
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private static class ParamConverterProviderPriorityComparator
    extends DescendingPriorityComparator<ParamConverterProvider> {
        private ParamConverterProviderPriorityComparator() {
            super(0);
        }
    }
}

