/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.extension.CSRFLiferayPortletURL;
import com.liferay.bean.portlet.spring.extension.internal.mvc.CsrfImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.LocaleResolverContextImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.UriInfoImpl;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import jakarta.mvc.MvcContext;
import jakarta.mvc.locale.LocaleResolver;
import jakarta.mvc.locale.LocaleResolverContext;
import jakarta.mvc.security.Csrf;
import jakarta.mvc.security.Encoders;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MVCContextImpl
implements MvcContext {
    private final Configuration _configuration;
    private final Csrf _csrf;
    private final Encoders _encoders;
    private final Locale _locale;
    private final PortletContext _portletContext;
    private final PortletRequest _portletRequest;

    public MVCContextImpl(Configuration configuration, Encoders encoders, List<LocaleResolver> localeResolvers, PortletContext portletContext, PortletRequest portletRequest) {
        LocaleResolver localeResolver;
        this._configuration = configuration;
        this._encoders = encoders;
        this._portletContext = portletContext;
        this._portletRequest = portletRequest;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        CSRFLiferayPortletURL csrfLiferayPortletURL = new CSRFLiferayPortletURL(portletDisplay.getId());
        AuthTokenUtil.addCSRFToken((HttpServletRequest)themeDisplay.getRequest(), (LiferayPortletURL)csrfLiferayPortletURL);
        this._csrf = new CsrfImpl("p_auth", csrfLiferayPortletURL.getParameter("p_auth"));
        HashMap<String, jakarta.ws.rs.core.Cookie> cookieMap = new HashMap<String, jakarta.ws.rs.core.Cookie>();
        Cookie[] cookies = portletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), new jakarta.ws.rs.core.Cookie(cookie.getName(), cookie.getValue()));
            }
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration enumeration = portletRequest.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String header = (String)enumeration.nextElement();
            headerMap.put(header, portletRequest.getProperty(header));
        }
        LocaleResolverContextImpl localeResolverContext = new LocaleResolverContextImpl(Collections.list(portletRequest.getLocales()), this._configuration, cookieMap, headerMap, new UriInfoImpl());
        Locale locale = null;
        Iterator<LocaleResolver> iterator = localeResolvers.iterator();
        while (iterator.hasNext() && (locale = (localeResolver = iterator.next()).resolveLocale((LocaleResolverContext)localeResolverContext)) == null) {
        }
        this._locale = locale;
    }

    public String getBasePath() {
        return this._portletContext.getContextPath();
    }

    public Configuration getConfig() {
        return this._configuration;
    }

    public Csrf getCsrf() {
        return this._csrf;
    }

    public Encoders getEncoders() {
        return this._encoders;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public URI uri(String identifier) {
        throw new UnsupportedOperationException();
    }

    public URI uri(String identifier, Map<String, Object> parameters) {
        throw new UnsupportedOperationException();
    }

    public UriBuilder uriBuilder(String identifier) {
        throw new UnsupportedOperationException();
    }
}

