/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeanPortletMethodInterceptor;
import com.liferay.bean.portlet.spring.extension.internal.mvc.MessageInterpolatorContextImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.MutableBindingResult;
import com.liferay.bean.portlet.spring.extension.internal.mvc.ValidationErrorImpl;
import jakarta.mvc.MvcContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Path;
import jakarta.validation.Validator;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;

public class BeanValidationInterceptor
extends BeanPortletMethodInterceptor {
    private final MessageInterpolator _messageInterpolator;
    private final MutableBindingResult _mutableBindingResult;
    private final MvcContext _mvcContext;
    private final Object _validationObject;
    private final Validator _validator;

    public BeanValidationInterceptor(BeanPortletMethod beanPortletMethod, boolean controller, MessageInterpolator messageInterpolator, MutableBindingResult mutableBindingResult, MvcContext mvcContext, Object validationObject, Validator validator) {
        super(beanPortletMethod, controller);
        this._messageInterpolator = messageInterpolator;
        this._mutableBindingResult = mutableBindingResult;
        this._mvcContext = mvcContext;
        this._validationObject = validationObject;
        this._validator = validator;
    }

    public Object invoke(Object ... args) throws ReflectiveOperationException {
        if (this._validator == null || !this.isController()) {
            return super.invoke(args);
        }
        Set constraintViolations = this._validator.validate(this._validationObject, new Class[0]);
        for (ConstraintViolation constraintViolation : constraintViolations) {
            Annotation[] annotations;
            Path propertyPath = constraintViolation.getPropertyPath();
            Path.Node lastPathNode = null;
            Iterator iterator = propertyPath.iterator();
            while (iterator.hasNext()) {
                Path.Node pathNode;
                lastPathNode = pathNode = (Path.Node)iterator.next();
            }
            if (lastPathNode == null || lastPathNode.getKind() != ElementKind.PROPERTY) continue;
            Object leafBean = constraintViolation.getLeafBean();
            Class<?> leafBeanClass = leafBean.getClass();
            Field field = leafBeanClass.getDeclaredField(lastPathNode.getName());
            String paramName = null;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (annotation instanceof CookieParam) {
                    CookieParam cookieParam = (CookieParam)annotation;
                    paramName = cookieParam.value();
                    break;
                }
                if (annotation instanceof FormParam) {
                    FormParam formParam = (FormParam)annotation;
                    paramName = formParam.value();
                    break;
                }
                if (annotation instanceof HeaderParam) {
                    HeaderParam headerParam = (HeaderParam)annotation;
                    paramName = headerParam.value();
                    break;
                }
                if (!(annotation instanceof QueryParam)) continue;
                QueryParam queryParam = (QueryParam)annotation;
                paramName = queryParam.value();
            }
            String interpolatedMessage = constraintViolation.getMessage();
            if (this._messageInterpolator != null) {
                interpolatedMessage = this._messageInterpolator.interpolate(constraintViolation.getMessageTemplate(), (MessageInterpolator.Context)new MessageInterpolatorContextImpl(constraintViolation), this._mvcContext.getLocale());
            }
            this._mutableBindingResult.addValidationError(new ValidationErrorImpl(constraintViolation, interpolatedMessage, paramName));
        }
        return super.invoke(args);
    }
}

