/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.extension.BeanPortletMethodDecorator;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeanValidationInterceptor;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeanValidationMessageInterpolator;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeanValidationValidator;
import com.liferay.bean.portlet.spring.extension.internal.mvc.ControllerInterceptor;
import com.liferay.bean.portlet.spring.extension.internal.mvc.CsrfValidationInterceptor;
import com.liferay.bean.portlet.spring.extension.internal.mvc.MutableBindingResult;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import jakarta.annotation.ManagedBean;
import jakarta.mvc.Controller;
import jakarta.mvc.MvcContext;
import jakarta.mvc.binding.BindingResult;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validator;
import jakarta.ws.rs.core.Configuration;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;

@ManagedBean(value="beanPortletMethodDecorator")
public class BeanPortletMethodDecoratorMVCImpl
implements ApplicationContextAware,
BeanPortletMethodDecorator {
    private static final Log _log = LogFactoryUtil.getLog(BeanPortletMethodDecoratorMVCImpl.class);
    private ApplicationContext _applicationContext;
    @Autowired
    private ApplicationEventPublisher _applicationEventPublisher;
    @Autowired
    private BindingResult _bindingResult;
    @Autowired
    private Configuration _configuration;
    @Autowired
    @BeanValidationMessageInterpolator
    private MessageInterpolator _messageInterpolator;
    @Autowired
    private MvcContext _mvcContext;
    @Autowired
    @BeanValidationValidator
    private Validator _validator;

    public BeanPortletMethod getBeanPortletMethod(BeanPortletMethod beanPortletMethod, PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) {
        boolean controller = this._isController(beanPortletMethod);
        Object eventObject = this._getEventObject(beanPortletMethod.getBeanClass());
        return new ControllerInterceptor(this._applicationEventPublisher, (BeanPortletMethod)new BeanValidationInterceptor((BeanPortletMethod)new CsrfValidationInterceptor(beanPortletMethod, this._configuration, controller), controller, this._messageInterpolator, (MutableBindingResult)this._bindingResult, this._mvcContext, eventObject, this._validator), controller, eventObject, portletRequest, portletResponse);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private Object _getEventObject(Class<?> beanClass) {
        Object eventObject = this._applicationContext.getBean(beanClass);
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(eventObject.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyDescriptorName = propertyDescriptor.getName();
                if (!propertyDescriptorName.equals("targetObject")) continue;
                Method method = propertyDescriptor.getReadMethod();
                eventObject = method.invoke(eventObject, new Object[0]);
                break;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return eventObject;
    }

    private boolean _isController(BeanPortletMethod beanPortletMethod) {
        Method method = beanPortletMethod.getMethod();
        if (method.isAnnotationPresent(Controller.class)) {
            return true;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass.isAnnotationPresent(Controller.class);
    }
}

