/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.scope;

import com.liferay.bean.portlet.extension.ScopedBean;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBean;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBeanManagerThreadLocal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.mvc.RedirectScoped;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.portlet.RenderResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.annotations.PortletSerializable;
import javax.portlet.annotations.RenderStateScoped;

public class SpringScopedBeanManager {
    private static final String _ATTRIBUTE_NAME_PREFIX = "com.liferay.spring.";
    private final Map<String, Runnable> _destructionCallbacks = new HashMap<String, Runnable>();
    private final PortletConfig _portletConfig;
    private final PortletRequest _portletRequest;
    private final PortletResponse _portletResponse;

    public SpringScopedBeanManager(PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) {
        this._portletConfig = portletConfig;
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
    }

    public void destroyScopedBeans() {
        Enumeration enumeration;
        if (this._portletResponse instanceof StateAwareResponse) {
            StateAwareResponse stateAwareResponse = (StateAwareResponse)this._portletResponse;
            enumeration = this._portletRequest.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Class<?> beanInstanceClass;
                RenderStateScoped renderStateScoped;
                ScopedBean scopedBean;
                Object beanInstance;
                Object attributeValue;
                String attributeName = (String)enumeration.nextElement();
                if (!attributeName.startsWith(_ATTRIBUTE_NAME_PREFIX) || !((attributeValue = this._portletRequest.getAttribute(attributeName)) instanceof ScopedBean) || !((beanInstance = (scopedBean = (ScopedBean)attributeValue).getContainerCreatedInstance()) instanceof PortletSerializable) || (renderStateScoped = (beanInstanceClass = beanInstance.getClass()).getAnnotation(RenderStateScoped.class)) == null) continue;
                PortletSerializable portletSerializable = (PortletSerializable)beanInstance;
                MutableRenderParameters mutableRenderParameters = stateAwareResponse.getRenderParameters();
                mutableRenderParameters.setValues(this._getParameterName(portletSerializable), portletSerializable.serialize());
            }
        }
        if (this._portletResponse instanceof RenderResponse) {
            PortletSession portletSession = this._portletRequest.getPortletSession(true);
            enumeration = portletSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                SpringScopedBean springScopedBean;
                String name = (String)enumeration.nextElement();
                Object value = portletSession.getAttribute(name);
                if (!(value instanceof ScopedBean) || !Objects.equals((springScopedBean = (SpringScopedBean)value).getScopeName(), RedirectScoped.class.getSimpleName())) continue;
                springScopedBean.destroy();
                portletSession.removeAttribute(name);
            }
        }
        Enumeration enumeration2 = this._portletRequest.getAttributeNames();
        while (enumeration2.hasMoreElements()) {
            String name = (String)enumeration2.nextElement();
            if (!name.startsWith(_ATTRIBUTE_NAME_PREFIX)) continue;
            Object value = this._portletRequest.getAttribute(name);
            if (value != null && value instanceof ScopedBean) {
                ScopedBean scopedBean = (ScopedBean)value;
                scopedBean.destroy();
            }
            this._portletRequest.removeAttribute(name);
        }
    }

    public PortletConfig getPortletConfig() {
        return this._portletConfig;
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public SpringScopedBean getPortletRequestScopedBean(String name) {
        name = _ATTRIBUTE_NAME_PREFIX.concat(name);
        return (SpringScopedBean)this._portletRequest.getAttribute(name);
    }

    public PortletResponse getPortletResponse() {
        return this._portletResponse;
    }

    public SpringScopedBean getPortletSessionScopedBean(int subscope, String name) {
        PortletSession portletSession = this._portletRequest.getPortletSession(true);
        return (SpringScopedBean)portletSession.getAttribute(_ATTRIBUTE_NAME_PREFIX.concat(name), subscope);
    }

    public SpringScopedBean getRedirectScopedBean(String name) {
        PortletSession portletSession = this._portletRequest.getPortletSession(true);
        return (SpringScopedBean)portletSession.getAttribute(_ATTRIBUTE_NAME_PREFIX.concat(name));
    }

    public SpringScopedBean getRenderStateScopedBean(String name) {
        return this.getPortletRequestScopedBean(name);
    }

    public void setDestructionCallback(String name, Runnable destructionCallback) {
        this._destructionCallbacks.put(name, destructionCallback);
    }

    public void setPortletRequestScopedBean(String name, SpringScopedBean springScopedBean) {
        name = _ATTRIBUTE_NAME_PREFIX.concat(name);
        this._portletRequest.setAttribute(name, (Object)springScopedBean);
    }

    public void setPortletSessionScopedBean(int subscope, String name, SpringScopedBean springScopedBean) {
        PortletSession portletSession = this._portletRequest.getPortletSession(true);
        portletSession.setAttribute(_ATTRIBUTE_NAME_PREFIX.concat(name), (Object)springScopedBean, subscope);
    }

    public void setRedirectScopedBean(String name, SpringScopedBean springScopedBean) {
        PortletSession portletSession = this._portletRequest.getPortletSession(true);
        portletSession.setAttribute(_ATTRIBUTE_NAME_PREFIX.concat(name), (Object)springScopedBean);
    }

    public void setRenderStateScopedBean(String name, SpringScopedBean springScopedBean) {
        PortletSerializable portletSerializable = (PortletSerializable)springScopedBean.getContainerCreatedInstance();
        String parameterName = this._getParameterName(portletSerializable);
        SpringScopedBeanManager springScopedBeanManager = SpringScopedBeanManagerThreadLocal.getCurrentScopedBeanManager();
        PortletRequest portletRequest = springScopedBeanManager.getPortletRequest();
        RenderParameters renderParameters = portletRequest.getRenderParameters();
        String[] parameterValues = renderParameters.getValues(parameterName);
        if (parameterValues == null) {
            parameterValues = new String[]{};
        }
        portletSerializable.deserialize(parameterValues);
        this.setPortletRequestScopedBean(name, springScopedBean);
    }

    public Runnable unsetDestructionCallback(String name) {
        return this._destructionCallbacks.remove(name);
    }

    private String _getParameterName(PortletSerializable portletSerializable) {
        String parameterName = null;
        Class beanClass = portletSerializable.getClass();
        RenderStateScoped renderStateScoped = beanClass.getAnnotation(RenderStateScoped.class);
        if (renderStateScoped != null) {
            parameterName = renderStateScoped.paramName();
        }
        if (parameterName == null || parameterName.isEmpty()) {
            parameterName = beanClass.getSimpleName();
        }
        return parameterName;
    }
}

