/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.spring.extension.internal.mvc.BindingErrorImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.MutableBindingResult;
import com.liferay.bean.portlet.spring.extension.internal.mvc.ParamConverterProviders;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.mvc.binding.BindingResult;
import javax.portlet.PortletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
public class PortletParamProducer
implements ApplicationContextAware {
    private static final Log _log = LogFactoryUtil.getLog(PortletParamProducer.class);
    private ApplicationContext _applicationContext;
    @Autowired
    private BindingResult _bindingResult;
    @Autowired
    @ParamConverterProviders
    private List<ParamConverterProvider> _paramConverterProviders;

    @Bean
    @Scope(value="prototype")
    public Boolean getBooleanParam(InjectionPoint injectionPoint) {
        String value = this.getStringParam(injectionPoint);
        if (value == null) {
            return null;
        }
        AnnotatedElement annotatedElement = injectionPoint.getAnnotatedElement();
        Annotation[] annotations = annotatedElement.getAnnotations();
        ParamConverter<Boolean> paramConverter = this._getParamConverter((Class)Boolean.class, (Type)((Object)Boolean.class), annotations);
        if (paramConverter != null) {
            try {
                return (Boolean)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(annotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Boolean");
        }
        return null;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Date getDateParam(InjectionPoint injectionPoint) {
        String value = this.getStringParam(injectionPoint);
        if (value == null) {
            return null;
        }
        AnnotatedElement annotatedElement = injectionPoint.getAnnotatedElement();
        Annotation[] annotations = annotatedElement.getAnnotations();
        ParamConverter<Date> paramConverter = this._getParamConverter((Class)Date.class, (Type)((Object)Date.class), annotations);
        if (paramConverter != null) {
            try {
                return (Date)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(annotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Date");
        }
        return null;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Double getDoubleParam(InjectionPoint injectionPoint) {
        String value = this.getStringParam(injectionPoint);
        if (value == null) {
            return null;
        }
        AnnotatedElement annotatedElement = injectionPoint.getAnnotatedElement();
        Annotation[] annotations = annotatedElement.getAnnotations();
        ParamConverter<Double> paramConverter = this._getParamConverter((Class)Double.class, (Type)((Object)Double.class), annotations);
        if (paramConverter != null) {
            try {
                return (Double)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(annotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Double");
        }
        return null;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Float getFloatParam(InjectionPoint injectionPoint) {
        String value = this.getStringParam(injectionPoint);
        if (value == null) {
            return null;
        }
        AnnotatedElement annotatedElement = injectionPoint.getAnnotatedElement();
        Annotation[] annotations = annotatedElement.getAnnotations();
        ParamConverter<Float> paramConverter = this._getParamConverter((Class)Float.class, (Type)((Object)Float.class), annotations);
        if (paramConverter != null) {
            try {
                return (Float)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(annotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Float");
        }
        return null;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Integer getIntegerParam(InjectionPoint injectionPoint) {
        String value = this.getStringParam(injectionPoint);
        if (value == null) {
            return null;
        }
        AnnotatedElement annotatedElement = injectionPoint.getAnnotatedElement();
        Annotation[] annotations = annotatedElement.getAnnotations();
        ParamConverter<Integer> paramConverter = this._getParamConverter((Class)Integer.class, (Type)((Object)Integer.class), annotations);
        if (paramConverter != null) {
            try {
                return (Integer)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(annotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Integer");
        }
        return null;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Long getLongParam(InjectionPoint injectionPoint) {
        String value = this.getStringParam(injectionPoint);
        if (value == null) {
            return null;
        }
        AnnotatedElement annotatedElement = injectionPoint.getAnnotatedElement();
        Annotation[] annotations = annotatedElement.getAnnotations();
        ParamConverter<Long> paramConverter = this._getParamConverter((Class)Long.class, (Type)((Object)Long.class), annotations);
        if (paramConverter != null) {
            try {
                return (Long)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(annotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Long");
        }
        return Long.valueOf(value);
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public String getStringParam(InjectionPoint injectionPoint) {
        CookieParam cookieParam;
        PortletRequest portletRequest = (PortletRequest)this._applicationContext.getBean(PortletRequest.class);
        AnnotatedElement annotatedElement = injectionPoint.getAnnotatedElement();
        String defaultValue = null;
        DefaultValue annotation = annotatedElement.getAnnotation(DefaultValue.class);
        if (annotation != null) {
            defaultValue = annotation.value();
        }
        if ((cookieParam = annotatedElement.getAnnotation(CookieParam.class)) != null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = portletRequest.getCookies()) {
                if (!Objects.equals(cookieParam.value(), cookie.getName())) continue;
                String cookieValue = cookie.getValue();
                if (cookieValue == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into an element ", "annotated with @CookieParam(\"", cookieParam.value(), "\") because the ", "cookie does not have a value"}));
                    }
                    return defaultValue;
                }
                return cookieValue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into an element annotated with @CookieParam(\"", cookieParam.value(), "\") because there is no cookie ", "with that name"}));
            }
            return defaultValue;
        }
        FormParam formParam = annotatedElement.getAnnotation(FormParam.class);
        if (formParam != null) {
            String lifecyclePhase = (String)portletRequest.getAttribute("javax.portlet.lifecycle_phase");
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            HttpServletRequest httpServletRequest = themeDisplay.getRequest();
            String httpMethod = httpServletRequest.getMethod();
            if (StringUtil.equalsIgnoreCase((String)httpMethod, (String)"post") && (lifecyclePhase.equals("ACTION_PHASE") || lifecyclePhase.equals("RESOURCE_PHASE"))) {
                String parameterValue = portletRequest.getParameter(formParam.value());
                if (parameterValue == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into an element annotated with ", "@FormParam(\"", formParam.value(), "\") ", "because the request parameter does not have ", "a value"}));
                    }
                    return defaultValue;
                }
                return parameterValue;
            }
            if (_log.isDebugEnabled()) {
                if (lifecyclePhase.equals("RENDER_PHASE")) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Injection into an element annotated with ", "@FormParam(\"", formParam.value(), "\") is ", "invalid during the RENDER_PHASE"}));
                } else {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Injection into an element annotated with ", "@FormParam(\"", formParam.value(), "\") is ", "invalid during the ", lifecyclePhase, " (HTTP ", httpMethod, ") request"}));
                }
            }
            return null;
        }
        HeaderParam headerParam = annotatedElement.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            Enumeration enumeration = portletRequest.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String propertyName = (String)enumeration.nextElement();
                if (!Objects.equals(headerParam.value(), propertyName)) continue;
                String headerValue = portletRequest.getProperty(propertyName);
                if (headerValue == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into an element ", "annotated with @HeaderParam(\"", headerParam.value(), "\") because the ", "header does not have a value"}));
                    }
                    return defaultValue;
                }
                return headerValue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into an element annotated with @HeaderParam(\"", headerParam.value(), "\") because there is no header ", "with that name"}));
            }
            return defaultValue;
        }
        QueryParam queryParam = annotatedElement.getAnnotation(QueryParam.class);
        if (queryParam != null) {
            String parameterValue = portletRequest.getParameter(queryParam.value());
            if (parameterValue == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into an element annotated with @QueryParam(\"", queryParam.value(), "\") because the request ", "parameter does not have a value"}));
                }
                return defaultValue;
            }
            return parameterValue;
        }
        return defaultValue;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private void _addBindingError(Annotation[] annotations, String message, String value) {
        MutableBindingResult mutableBindingResult = (MutableBindingResult)this._bindingResult;
        if (mutableBindingResult == null) {
            _log.error((Object)"Unable to add a binding error");
        } else {
            mutableBindingResult.addBindingError(new BindingErrorImpl(message, this._getParamName(annotations), value));
        }
    }

    private <T> ParamConverter<T> _getParamConverter(Class<T> rawType, Type baseType, Annotation[] annotations) {
        for (ParamConverterProvider paramConverterProvider : this._paramConverterProviders) {
            ParamConverter paramConverter = paramConverterProvider.getConverter(rawType, baseType, annotations);
            if (paramConverter == null) continue;
            return paramConverter;
        }
        return null;
    }

    private String _getParamName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<?> annotationClass = annotation.getClass();
            if (CookieParam.class.isAssignableFrom(annotationClass)) {
                CookieParam cookieParam = (CookieParam)annotation;
                return cookieParam.value();
            }
            if (FormParam.class.isAssignableFrom(annotationClass)) {
                FormParam formParam = (FormParam)annotation;
                return formParam.value();
            }
            if (HeaderParam.class.isAssignableFrom(annotationClass)) {
                HeaderParam headerParam = (HeaderParam)annotation;
                return headerParam.value();
            }
            if (!QueryParam.class.isAssignableFrom(annotationClass)) continue;
            QueryParam queryParam = (QueryParam)annotation;
            return queryParam.value();
        }
        return null;
    }
}

