/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeanPortletMethodInterceptor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;
import javax.mvc.security.Csrf;
import javax.mvc.security.CsrfProtected;
import javax.portlet.ClientDataRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Configuration;

public class CsrfValidationInterceptor
extends BeanPortletMethodInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(CsrfValidationInterceptor.class);
    private final Configuration _configuration;
    private final Method _method;

    public CsrfValidationInterceptor(BeanPortletMethod beanPortletMethod, Configuration configuration, boolean controller) {
        super(beanPortletMethod, controller);
        this._configuration = configuration;
        this._method = beanPortletMethod.getMethod();
    }

    public Object invoke(Object ... args) throws ReflectiveOperationException {
        if (!this.isController()) {
            return super.invoke(args);
        }
        Csrf.CsrfOptions csrfOptions = Csrf.CsrfOptions.EXPLICIT;
        Object csrfProtection = this._configuration.getProperty("javax.mvc.security.CsrfProtection");
        if (csrfProtection != null) {
            if (csrfProtection instanceof Csrf.CsrfOptions) {
                csrfOptions = (Csrf.CsrfOptions)csrfProtection;
            } else {
                try {
                    csrfOptions = Csrf.CsrfOptions.valueOf((String)csrfProtection.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _log.error((Throwable)illegalArgumentException);
                }
            }
        }
        if (csrfOptions == Csrf.CsrfOptions.OFF || csrfOptions == Csrf.CsrfOptions.EXPLICIT && !this._method.isAnnotationPresent(CsrfProtected.class)) {
            return super.invoke(args);
        }
        boolean proceed = false;
        if (args.length == 2) {
            if (args[0] instanceof ClientDataRequest) {
                ClientDataRequest clientDataRequest = (ClientDataRequest)args[0];
                String method = StringUtil.toLowerCase((String)clientDataRequest.getMethod());
                if (method.equals("post")) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)clientDataRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    try {
                        AuthTokenUtil.checkCSRFToken((HttpServletRequest)themeDisplay.getRequest(), (String)CsrfValidationInterceptor.class.getName());
                        proceed = true;
                    }
                    catch (PrincipalException principalException) {
                        _log.error((Object)"Invalid CSRF token", (Throwable)principalException);
                    }
                } else {
                    proceed = true;
                }
            } else {
                _log.error((Object)"The first parameter of the method signature must be an ActionRequest or ResourceRequest");
            }
        } else {
            _log.error((Object)"The method signature must include (ActionRequest, ActionResponse) or (ResourceRequest, ResourceResponse) as parameters");
        }
        if (proceed) {
            return super.invoke(args);
        }
        return null;
    }
}

