/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal;

import com.liferay.bean.portlet.spring.extension.internal.JSR330InjectedFieldElement;
import com.liferay.bean.portlet.spring.extension.internal.JSR330InjectedMethodElement;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JSR330BeanPortletPostProcessor
extends AutowiredAnnotationBeanPostProcessor {
    private static final Log _log = LogFactoryUtil.getLog(JSR330BeanPortletPostProcessor.class);
    private final Set<Class<? extends Annotation>> _autowiredAnnotationTypes;
    private ConfigurableListableBeanFactory _configurableListableBeanFactory;
    private final Map<String, InjectionMetadata> _injectionMetadataCache;

    public JSR330BeanPortletPostProcessor() {
        block2: {
            this._autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
            this._injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>();
            this._autowiredAnnotationTypes.add(Autowired.class);
            try {
                Class injectAnnotation = ClassUtils.forName((String)"javax.inject.Inject", (ClassLoader)JSR330BeanPortletPostProcessor.class.getClassLoader());
                this._autowiredAnnotationTypes.add(injectAnnotation);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)classNotFoundException);
            }
        }
        this._autowiredAnnotationTypes.add(Value.class);
    }

    public PropertyValues postProcessProperties(PropertyValues propertyValues, Object beanInstance, String beanName) {
        InjectionMetadata injectionMetadata = this._getInjectionMetadata(beanInstance.getClass(), beanName, propertyValues);
        try {
            injectionMetadata.inject(beanInstance, beanName, propertyValues);
        }
        catch (Throwable throwable) {
            if (throwable instanceof BeanCreationException) {
                throw (RuntimeException)throwable;
            }
            throw new BeanCreationException(beanName, "Unable to @Inject dependencies", throwable);
        }
        return propertyValues;
    }

    public void processInjection(Object beanInstance) {
        Class<?> beanClass = beanInstance.getClass();
        InjectionMetadata injectionMetadata = this._getInjectionMetadata(beanClass, beanClass.getName(), null);
        try {
            injectionMetadata.inject(beanInstance, null, null);
        }
        catch (Throwable throwable) {
            if (throwable instanceof BeanCreationException) {
                throw (RuntimeException)throwable;
            }
            throw new BeanCreationException("Unable to @Inject dependencies");
        }
    }

    public void resetBeanDefinition(String beanName) {
        super.resetBeanDefinition(beanName);
        this._injectionMetadataCache.remove(beanName);
    }

    public void setAutowiredAnnotationType(Class<? extends Annotation> autowiredAnnotationType) {
        super.setAutowiredAnnotationType(autowiredAnnotationType);
        this._autowiredAnnotationTypes.clear();
        this._autowiredAnnotationTypes.add(autowiredAnnotationType);
    }

    public void setAutowiredAnnotationTypes(Set<Class<? extends Annotation>> autowiredAnnotationTypes) {
        super.setAutowiredAnnotationTypes(autowiredAnnotationTypes);
        this._autowiredAnnotationTypes.clear();
        this._autowiredAnnotationTypes.addAll(autowiredAnnotationTypes);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this._configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private AnnotationAttributes _getAnnotationAttributes(AccessibleObject accessibleObject) {
        Annotation[] annotations = accessibleObject.getAnnotations();
        if (annotations.length <= 0) {
            return null;
        }
        for (Class<? extends Annotation> autowiredAnnotationType : this._autowiredAnnotationTypes) {
            AnnotationAttributes mergedAnnotationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)accessibleObject, autowiredAnnotationType);
            if (mergedAnnotationAttributes == null) continue;
            return mergedAnnotationAttributes;
        }
        return null;
    }

    private InjectionMetadata _getInjectionMetadata(Class<?> beanClass) {
        ArrayList injectedElements = new ArrayList();
        for (Class<?> curClass = beanClass; curClass != null && curClass != Object.class; curClass = curClass.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            ArrayList<InjectionMetadata.InjectedElement> injectionElements = new ArrayList<InjectionMetadata.InjectedElement>();
            for (Field field : fields = curClass.getDeclaredFields()) {
                AnnotationAttributes annotationAttributes = this._getAnnotationAttributes(field);
                if (annotationAttributes == null || Modifier.isStatic(field.getModifiers())) continue;
                boolean required = this.determineRequiredStatus(annotationAttributes);
                injectionElements.add(new JSR330InjectedFieldElement(this._configurableListableBeanFactory, field, required));
            }
            for (Method method : methods = curClass.getDeclaredMethods()) {
                AnnotationAttributes annotationAttributes;
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod) || (annotationAttributes = this._getAnnotationAttributes(bridgedMethod)) == null || !method.equals(ClassUtils.getMostSpecificMethod((Method)method, beanClass)) || Modifier.isStatic(method.getModifiers())) continue;
                PropertyDescriptor propertyDescriptor = BeanUtils.findPropertyForMethod((Method)bridgedMethod, beanClass);
                boolean required = this.determineRequiredStatus(annotationAttributes);
                injectionElements.add(new JSR330InjectedMethodElement(this._configurableListableBeanFactory, method, propertyDescriptor, required));
            }
            injectedElements.addAll(0, injectionElements);
        }
        return new InjectionMetadata(beanClass, injectedElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata _getInjectionMetadata(Class<?> beanClass, String beanName, PropertyValues propertyValues) {
        InjectionMetadata injectionMetadata;
        String key = beanName;
        if (StringUtils.isEmpty((Object)key)) {
            key = beanClass.getName();
        }
        if (InjectionMetadata.needsRefresh((InjectionMetadata)(injectionMetadata = this._injectionMetadataCache.get(key)), beanClass)) {
            Map<String, InjectionMetadata> map = this._injectionMetadataCache;
            synchronized (map) {
                injectionMetadata = this._injectionMetadataCache.get(key);
                if (InjectionMetadata.needsRefresh((InjectionMetadata)injectionMetadata, beanClass)) {
                    if (injectionMetadata != null) {
                        injectionMetadata.clear(propertyValues);
                    }
                    injectionMetadata = this._getInjectionMetadata(beanClass);
                    this._injectionMetadataCache.put(key, injectionMetadata);
                }
            }
        }
        return injectionMetadata;
    }
}

