/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.extension.ViewRenderer;
import com.liferay.bean.portlet.spring.extension.internal.mvc.AfterProcessViewEventImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeforeProcessViewEventImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.DescendingPriorityComparator;
import com.liferay.bean.portlet.spring.extension.internal.mvc.MutableBindingResult;
import com.liferay.bean.portlet.spring.extension.internal.mvc.ViewEngineContextImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.ManagedBean;
import javax.mvc.Models;
import javax.mvc.binding.BindingResult;
import javax.mvc.binding.ParamError;
import javax.mvc.engine.ViewEngine;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.ws.rs.core.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@ManagedBean(value="viewRenderer")
public class ViewRendererMVCImpl
implements ApplicationContextAware,
ViewRenderer {
    private static final Log _log = LogFactoryUtil.getLog(ViewRendererMVCImpl.class);
    private ApplicationContext _applicationContext;
    @Autowired
    private ApplicationEventPublisher _applicationEventPublisher;
    @Autowired
    private BindingResult _bindingResult;
    @Autowired
    private Configuration _configuration;
    @Autowired
    private Models _models;

    public void render(MimeResponse mimeResponse, PortletConfig portletConfig, PortletRequest portletRequest) throws PortletException {
        MutableBindingResult mutableBindingResult;
        PortletSession portletSession;
        String redirectedView;
        Map modelMap = this._models.asMap();
        for (Map.Entry entry : modelMap.entrySet()) {
            portletRequest.setAttribute((String)entry.getKey(), entry.getValue());
        }
        String viewName = (String)portletRequest.getAttribute("viewName");
        if (viewName == null && (redirectedView = portletRequest.getParameter("redirectedView")) != null && (viewName = (String)(portletSession = portletRequest.getPortletSession(true)).getAttribute("viewName")) != null) {
            portletSession.removeAttribute("viewName");
            portletRequest.setAttribute("viewName", (Object)viewName);
        }
        if (viewName != null) {
            if (!viewName.contains(".")) {
                String defaultViewExtension = (String)this._configuration.getProperty("com.liferay.mvc.defaultViewExtension");
                viewName = StringBundler.concat((String[])new String[]{viewName, ".", defaultViewExtension});
            }
            Map beansOfType = this._applicationContext.getBeansOfType(ViewEngine.class);
            ArrayList viewEngines = new ArrayList(beansOfType.values());
            Collections.sort(viewEngines, new ViewEnginePriorityComparator());
            ViewEngine supportingViewEngine = null;
            for (ViewEngine viewEngine : viewEngines) {
                if (!viewEngine.supports(viewName)) continue;
                supportingViewEngine = viewEngine;
                break;
            }
            if (supportingViewEngine == null) {
                throw new PortletException((Throwable)new ViewEngineException("No ViewEngine found that supports " + viewName));
            }
            try {
                this._applicationEventPublisher.publishEvent((ApplicationEvent)new BeforeProcessViewEventImpl(this, viewName, supportingViewEngine.getClass()));
                supportingViewEngine.processView((ViewEngineContext)new ViewEngineContextImpl(this._configuration, mimeResponse, this._models, portletRequest));
                this._applicationEventPublisher.publishEvent((ApplicationEvent)new AfterProcessViewEventImpl(this, viewName, supportingViewEngine.getClass()));
            }
            catch (ViewEngineException viewEngineException) {
                throw new PortletException((Throwable)viewEngineException);
            }
        }
        if ((mutableBindingResult = (MutableBindingResult)this._bindingResult) != null && !mutableBindingResult.isConsulted()) {
            Set allErrors = mutableBindingResult.getAllErrors();
            for (ParamError paramError : allErrors) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"A BindingResult error was not processed for ", paramError.getParamName(), ": ", paramError.getMessage()}));
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private static class ViewEnginePriorityComparator
    extends DescendingPriorityComparator<ViewEngine> {
        private ViewEnginePriorityComparator() {
            super(3000);
        }
    }
}

