/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import javax.annotation.ManagedBean;
import javax.annotation.Priority;
import javax.mvc.engine.ViewEngine;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.ws.rs.core.Configuration;

@ManagedBean
@Priority(value=1000)
public class ViewEngineJspImpl
implements ViewEngine {
    private final Configuration _configuration;
    private final PortletContext _portletContext;

    public ViewEngineJspImpl(Configuration configuration, PortletContext portletContext) {
        this._configuration = configuration;
        this._portletContext = portletContext;
    }

    public void processView(ViewEngineContext viewEngineContext) throws ViewEngineException {
        String view = viewEngineContext.getView();
        String viewFolder = (String)this._configuration.getProperty("javax.mvc.engine.ViewEngine.viewFolder");
        if (viewFolder == null) {
            viewFolder = "/WEB-INF/views/";
        }
        String viewPath = viewFolder.concat(view);
        PortletRequestDispatcher requestDispatcher = this._portletContext.getRequestDispatcher(viewPath);
        try {
            requestDispatcher.include((PortletRequest)viewEngineContext.getRequest(PortletRequest.class), (PortletResponse)viewEngineContext.getResponse(PortletResponse.class));
        }
        catch (Exception exception) {
            throw new ViewEngineException((Throwable)exception);
        }
    }

    public boolean supports(String view) {
        return view != null && (view.endsWith(".jsp") || view.endsWith(".jspx"));
    }
}

