/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.portal.kernel.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.ManagedBean;
import javax.portlet.PortletRequest;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.springframework.beans.factory.annotation.Autowired;

@ManagedBean
public class ParamConverterProviderImpl
implements ParamConverterProvider {
    @Autowired
    private PortletRequest _portletRequest;

    public <T> ParamConverter<T> getConverter(final Class<T> clazz, Type genericType, Annotation[] annotations) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) || clazz.equals(Long.class) || clazz.equals(Long.TYPE) || clazz.equals(Double.class) || clazz.equals(Double.TYPE) || clazz.equals(Float.class) || clazz.equals(Float.TYPE) || clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    if (value == null) {
                        throw new IllegalArgumentException("Unable to convert a null parameter value");
                    }
                    if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                        return this._getNumber(value, number -> number.intValue());
                    }
                    if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                        return this._getNumber(value, number -> number.longValue());
                    }
                    if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                        return this._getNumber(value, number -> number.doubleValue());
                    }
                    if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                        return this._getNumber(value, number -> Float.valueOf(number.floatValue()));
                    }
                    if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                        value = value.trim();
                        if (Boolean.valueOf(value = StringUtil.toLowerCase((String)value)).booleanValue()) {
                            return clazz.cast(Boolean.TRUE);
                        }
                        return clazz.cast(value.equals("on"));
                    }
                    return null;
                }

                public String toString(T value) {
                    if (value == null) {
                        return "";
                    }
                    return value.toString();
                }

                private T _getNumber(String value, Function<Number, ?> getNumberFunction) {
                    NumberFormat numberFormat = NumberFormat.getInstance(ParamConverterProviderImpl.this._portletRequest.getLocale());
                    try {
                        Number number = numberFormat.parse(value);
                        return clazz.cast(getNumberFunction.apply(number));
                    }
                    catch (ParseException parseException) {
                        throw new IllegalArgumentException(parseException);
                    }
                }
            };
        }
        return null;
    }
}

