/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.spring.extension.internal.mvc.UriInfoImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.mvc.engine.ViewEngineContext;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public abstract class BaseViewEngineContext
implements ViewEngineContext {
    private static final Log _log = LogFactoryUtil.getLog(BaseViewEngineContext.class);
    private MediaType _mediaType;

    public Locale getLocale() {
        PortletRequest portletRequest = this.getPortletRequest();
        return portletRequest.getLocale();
    }

    public MediaType getMediaType() {
        if (this._mediaType == null) {
            MimeResponse mimeResponse = this.getMimeResponse();
            String contentType = mimeResponse.getContentType();
            if (contentType == null) {
                this._mediaType = MediaType.TEXT_HTML_TYPE;
            } else {
                String type = contentType;
                String subtype = null;
                int pos = contentType.indexOf(47);
                if (pos > 0) {
                    type = contentType.substring(0, pos);
                    subtype = contentType.substring(pos + 1);
                }
                this._mediaType = new MediaType(type, subtype, mimeResponse.getCharacterEncoding());
            }
        }
        return this._mediaType;
    }

    public OutputStream getOutputStream() {
        try {
            MimeResponse mimeResponse = this.getMimeResponse();
            return mimeResponse.getPortletOutputStream();
        }
        catch (IOException ioException) {
            _log.error((Object)ioException, (Throwable)ioException);
            return null;
        }
    }

    public <T> T getRequest(Class<T> clazz) {
        return clazz.cast(this.getPortletRequest());
    }

    public ResourceInfo getResourceInfo() {
        throw new UnsupportedOperationException();
    }

    public <T> T getResponse(Class<T> clazz) {
        return clazz.cast(this.getMimeResponse());
    }

    public MultivaluedMap<String, Object> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl();
    }

    public String getView() {
        PortletRequest portletRequest = this.getPortletRequest();
        return (String)portletRequest.getAttribute("viewName");
    }

    protected abstract MimeResponse getMimeResponse();

    protected abstract PortletRequest getPortletRequest();
}

