/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal;

import com.liferay.bean.portlet.spring.extension.internal.SpringHttpSessionListener;
import com.liferay.bean.portlet.spring.extension.internal.SpringServletContextListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.net.URL;
import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SpringServletContainerInitializer
implements ServletContainerInitializer {
    private static final String _APP_CONTEXT_DESCRIPTOR = "/WEB-INF/applicationContext.xml";
    private static final String _CONTEXT_CONFIG_CLASSPATH_LOCATION = "classpath:/META-INF/springBeanPortletContext.xml";
    private static final String _PORTLET_APP_CONTEXT_DESCRIPTOR = "/WEB-INF/spring-context/portlet-application-context.xml";
    private static final Log _log = LogFactoryUtil.getLog(SpringServletContainerInitializer.class);

    public void onStartup(Set<Class<?>> scannedClasses, ServletContext servletContext) {
        try {
            String contextConfigLocation;
            Class<?> discoveredClass = Class.forName("org.springframework.web.context.ContextLoaderListener");
            if (EventListener.class.isAssignableFrom(discoveredClass)) {
                Class<?> contextLoaderListenerClass = discoveredClass;
                servletContext.addListener(contextLoaderListenerClass);
            }
            if ((contextConfigLocation = servletContext.getInitParameter("contextConfigLocation")) == null) {
                contextConfigLocation = _CONTEXT_CONFIG_CLASSPATH_LOCATION;
                BundleContext bundleContext = (BundleContext)servletContext.getAttribute("osgi-bundlecontext");
                Bundle bundle = bundleContext.getBundle();
                URL applicationContextDescriptorURL = bundle.getEntry(_APP_CONTEXT_DESCRIPTOR);
                if (applicationContextDescriptorURL == null) {
                    applicationContextDescriptorURL = bundle.getEntry(_PORTLET_APP_CONTEXT_DESCRIPTOR);
                    if (applicationContextDescriptorURL == null) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)StringBundler.concat((String[])new String[]{"Neither ", _APP_CONTEXT_DESCRIPTOR, " or ", _PORTLET_APP_CONTEXT_DESCRIPTOR, " were found"}));
                        }
                    } else {
                        contextConfigLocation = contextConfigLocation.concat(" ");
                        contextConfigLocation = contextConfigLocation.concat(_PORTLET_APP_CONTEXT_DESCRIPTOR);
                    }
                } else {
                    contextConfigLocation = contextConfigLocation.concat(" ");
                    contextConfigLocation = contextConfigLocation.concat(_APP_CONTEXT_DESCRIPTOR);
                }
                servletContext.setInitParameter("contextConfigLocation", contextConfigLocation);
            } else if (!contextConfigLocation.contains(_CONTEXT_CONFIG_CLASSPATH_LOCATION)) {
                servletContext.setInitParameter("contextConfigLocation", StringBundler.concat((String[])new String[]{_CONTEXT_CONFIG_CLASSPATH_LOCATION, " ", contextConfigLocation}));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            _log.error((Object)classNotFoundException, (Throwable)classNotFoundException);
        }
        servletContext.addListener(SpringHttpSessionListener.class);
        servletContext.addListener(SpringServletContextListener.class);
    }
}

