/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal;

import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBeanManager;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBeanManagerThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.async.PortletAsyncScopeManager;
import java.io.Closeable;
import java.io.IOException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public class SpringPortletAsyncScopeManager
implements PortletAsyncScopeManager {
    private static final Log _log = LogFactoryUtil.getLog(SpringPortletAsyncScopeManager.class);
    private Closeable _closeable;
    private final Runnable _scopedBeanManagersInstallRunnable = SpringScopedBeanManagerThreadLocal.captureScopedBeanManagers();

    public void activateScopeContexts() {
        this._scopedBeanManagersInstallRunnable.run();
    }

    public void activateScopeContexts(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletConfig portletConfig) {
        if (this._closeable != null) {
            throw new IllegalStateException("Allready called activateScopeContexts");
        }
        this._closeable = SpringScopedBeanManagerThreadLocal.install(new SpringScopedBeanManager(portletConfig, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse));
    }

    public void deactivateScopeContexts(boolean close) {
        if (!close) {
            SpringScopedBeanManagerThreadLocal.remove();
            return;
        }
        try {
            this._closeable.close();
        }
        catch (IOException ioException) {
            _log.error((Object)ioException, (Throwable)ioException);
        }
    }
}

