/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.AfterProcessViewEventImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanUtil;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeforeProcessViewEventImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.MutableBindingResult;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ViewEngineContextImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ViewEngines;
import com.liferay.bean.portlet.extension.ViewRenderer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.mvc.Models;
import jakarta.mvc.binding.ParamError;
import jakarta.mvc.engine.ViewEngine;
import jakarta.mvc.engine.ViewEngineContext;
import jakarta.mvc.engine.ViewEngineException;
import jakarta.portlet.MimeResponse;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletException;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletSession;
import jakarta.ws.rs.core.Configuration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewRendererMVCImpl
implements ViewRenderer {
    private static final Log _log = LogFactoryUtil.getLog(ViewRendererMVCImpl.class);
    private static final Annotation _viewEngines = new ViewEngines(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return ViewEngines.class;
        }
    };
    private static final TypeLiteral<?> _viewEnginesTypeLiteral = new TypeLiteral<List<ViewEngine>>(){};
    private final BeanManager _beanManager;
    private final boolean _importsMvcBindingPackage;
    private final boolean _importsMvcPackage;

    public ViewRendererMVCImpl(BeanManager beanManager, boolean importsMvcBindingPackage, boolean importsMvcPackage) {
        this._beanManager = beanManager;
        this._importsMvcBindingPackage = importsMvcBindingPackage;
        this._importsMvcPackage = importsMvcPackage;
    }

    public void render(MimeResponse mimeResponse, PortletConfig portletConfig, PortletRequest portletRequest) throws PortletException {
        PortletSession portletSession;
        String redirectedView;
        if (!this._importsMvcPackage) {
            return;
        }
        Models models = this._getModels(this._beanManager);
        Map modelMap = models.asMap();
        for (Map.Entry entry : modelMap.entrySet()) {
            portletRequest.setAttribute((String)entry.getKey(), entry.getValue());
        }
        String viewName = (String)portletRequest.getAttribute("viewName");
        if (viewName == null && (redirectedView = portletRequest.getParameter("redirectedView")) != null && (viewName = (String)(portletSession = portletRequest.getPortletSession(true)).getAttribute("viewName")) != null) {
            portletSession.removeAttribute("viewName");
            portletRequest.setAttribute("viewName", (Object)viewName);
        }
        if (viewName != null) {
            Configuration configuration = this._getConfiguration(this._beanManager);
            if (!viewName.contains(".")) {
                String defaultViewExtension = (String)configuration.getProperty("com.liferay.mvc.defaultViewExtension");
                viewName = StringBundler.concat((String[])new String[]{viewName, ".", defaultViewExtension});
            }
            ViewEngine supportingViewEngine = null;
            List<ViewEngine> viewEngines = this._getViewEngines(this._beanManager);
            for (ViewEngine viewEngine : viewEngines) {
                if (!viewEngine.supports(viewName)) continue;
                supportingViewEngine = viewEngine;
                break;
            }
            if (supportingViewEngine == null) {
                throw new PortletException((Throwable)new ViewEngineException("No ViewEngine found that supports " + viewName));
            }
            try {
                Event event = this._beanManager.getEvent();
                event.fire((Object)new BeforeProcessViewEventImpl(viewName, supportingViewEngine.getClass()));
                supportingViewEngine.processView((ViewEngineContext)new ViewEngineContextImpl(configuration, portletRequest.getLocale(), mimeResponse, models, portletRequest));
                event.fire((Object)new AfterProcessViewEventImpl(viewName, supportingViewEngine.getClass()));
            }
            catch (ViewEngineException viewEngineException) {
                throw new PortletException((Throwable)viewEngineException);
            }
        }
        if (!this._importsMvcBindingPackage) {
            return;
        }
        MutableBindingResult mutableBindingResult = BeanUtil.getMutableBindingResult(this._beanManager);
        if (mutableBindingResult == null || mutableBindingResult.isConsulted()) {
            return;
        }
        Set paramErrors = mutableBindingResult.getAllErrors();
        for (ParamError paramError : paramErrors) {
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)StringBundler.concat((String[])new String[]{"A BindingResult error was not processed for ", paramError.getParamName(), ": ", paramError.getMessage()}));
        }
    }

    private Configuration _getConfiguration(BeanManager beanManager) {
        Bean bean = beanManager.resolve(beanManager.getBeans(Configuration.class, new Annotation[0]));
        return (Configuration)beanManager.getReference(bean, Configuration.class, beanManager.createCreationalContext((Contextual)bean));
    }

    private Models _getModels(BeanManager beanManager) {
        Bean bean = beanManager.resolve(beanManager.getBeans(Models.class, new Annotation[0]));
        return (Models)beanManager.getReference(bean, Models.class, beanManager.createCreationalContext((Contextual)bean));
    }

    private List<ViewEngine> _getViewEngines(BeanManager beanManager) {
        ArrayList<ViewEngine> viewEngines = new ArrayList<ViewEngine>();
        Set beans = beanManager.getBeans(_viewEnginesTypeLiteral.getType(), new Annotation[]{_viewEngines});
        Bean bean = beanManager.resolve(beans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Object reference = beanManager.getReference(bean, _viewEnginesTypeLiteral.getType(), creationalContext);
        if (reference instanceof List) {
            List list = (List)reference;
            for (Object object : list) {
                if (!(object instanceof ViewEngine)) continue;
                viewEngines.add((ViewEngine)object);
            }
        }
        return viewEngines;
    }
}

