/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.BaseDescendingPriorityComparator;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanUtil;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ViewEngineJspImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ViewEngines;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.mvc.engine.ViewEngine;
import jakarta.portlet.PortletContext;
import jakarta.ws.rs.core.Configuration;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

@ApplicationScoped
public class ViewEnginesProducer {
    @ApplicationScoped
    @Produces
    @ViewEngines
    public List<ViewEngine> getViewEngines(BeanManager beanManager, Configuration configuration, PortletContext portletContext) {
        List<ViewEngine> viewEngines = BeanUtil.getBeanInstances(beanManager, ViewEngine.class, new Annotation[0]);
        viewEngines.add(new ViewEngineJspImpl(configuration, portletContext));
        Collections.sort(viewEngines, new ViewEnginePriorityComparator());
        return viewEngines;
    }

    private static class ViewEnginePriorityComparator
    extends BaseDescendingPriorityComparator<ViewEngine> {
        private ViewEnginePriorityComparator() {
            super(3000);
        }
    }
}

