/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.BaseDescendingPriorityComparator;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanUtil;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.LocaleResolverImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.MVCContextImpl;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mvc.MvcContext;
import jakarta.mvc.locale.LocaleResolver;
import jakarta.mvc.security.Encoders;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.annotations.PortletRequestScoped;
import jakarta.ws.rs.core.Configuration;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

@ApplicationScoped
public class MVCContextProducer {
    @Inject
    private BeanManager _beanManager;
    private List<LocaleResolver> _localeResolvers;

    @Named(value="mvc")
    @PortletRequestScoped
    @Produces
    public MvcContext getMvcContext(Configuration configuration, Encoders encoders, PortletContext portletContext, PortletRequest portletRequest) {
        return new MVCContextImpl(configuration, encoders, this._localeResolvers, portletContext, portletRequest);
    }

    @PostConstruct
    public void postConstruct() {
        this._localeResolvers = BeanUtil.getBeanInstances(this._beanManager, LocaleResolver.class, new Annotation[0]);
        this._localeResolvers.add(new LocaleResolverImpl());
        Collections.sort(this._localeResolvers, new LocaleResolverPriorityComparator());
    }

    private static class LocaleResolverPriorityComparator
    extends BaseDescendingPriorityComparator<LocaleResolver> {
        private LocaleResolverPriorityComparator() {
            super(1000);
        }
    }
}

