/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.MutableBindingResult;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.mvc.binding.BindingResult;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BeanUtil {
    private static final Log _log = LogFactoryUtil.getLog(BeanUtil.class);

    public static <T> List<T> getBeanInstances(BeanManager beanManager, Class<T> clazz, Annotation ... qualifiers) {
        ArrayList<T> beanInstances = new ArrayList<T>();
        if (qualifiers == null) {
            qualifiers = new Annotation[]{};
        }
        Set beans = beanManager.getBeans(clazz, qualifiers);
        for (Bean bean : beans) {
            beanInstances.add(clazz.cast(beanManager.getReference(bean, clazz, beanManager.createCreationalContext((Contextual)bean))));
        }
        return beanInstances;
    }

    public static MutableBindingResult getMutableBindingResult(BeanManager beanManager) {
        Bean bean = beanManager.resolve(beanManager.getBeans(BindingResult.class, new Annotation[0]));
        BindingResult bindingResult = (BindingResult)beanManager.getReference(bean, BindingResult.class, beanManager.createCreationalContext((Contextual)bean));
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bindingResult.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            Object targetInstance = null;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String propertyDescriptorName = propertyDescriptor.getName();
                if (!propertyDescriptorName.equals("targetInstance")) continue;
                Method method = propertyDescriptor.getReadMethod();
                targetInstance = method.invoke((Object)bindingResult, new Object[0]);
            }
            if (targetInstance instanceof MutableBindingResult) {
                return (MutableBindingResult)targetInstance;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return null;
    }
}

