/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.scope;

import com.liferay.bean.portlet.cdi.extension.internal.scope.CDIScopedBean;
import com.liferay.bean.portlet.extension.ScopedBean;
import java.util.Enumeration;
import java.util.Objects;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.mvc.RedirectScoped;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.portlet.RenderResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.annotations.PortletRequestScoped;
import javax.portlet.annotations.PortletSerializable;
import javax.portlet.annotations.PortletSessionScoped;
import javax.portlet.annotations.RenderStateScoped;

public class ScopedBeanManager {
    private static final String _ATTRIBUTE_NAME_PREFIX = "com.liferay.cdi.";
    private final PortletConfig _portletConfig;
    private final PortletRequest _portletRequest;
    private final PortletResponse _portletResponse;

    public ScopedBeanManager(PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) {
        this._portletConfig = portletConfig;
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
    }

    public void destroyScopedBeans() {
        Enumeration enumeration;
        if (this._portletResponse instanceof StateAwareResponse) {
            StateAwareResponse stateAwareResponse = (StateAwareResponse)this._portletResponse;
            enumeration = this._portletRequest.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Class<?> beanInstanceClass;
                RenderStateScoped renderStateScoped;
                ScopedBean scopedBean;
                Object beanInstance;
                Object attributeValue;
                String attributeName = (String)enumeration.nextElement();
                if (!attributeName.startsWith(_ATTRIBUTE_NAME_PREFIX) || !((attributeValue = this._portletRequest.getAttribute(attributeName)) instanceof ScopedBean) || !((beanInstance = (scopedBean = (ScopedBean)attributeValue).getContainerCreatedInstance()) instanceof PortletSerializable) || (renderStateScoped = (beanInstanceClass = beanInstance.getClass()).getAnnotation(RenderStateScoped.class)) == null) continue;
                PortletSerializable portletSerializable = (PortletSerializable)beanInstance;
                MutableRenderParameters mutableRenderParameters = stateAwareResponse.getRenderParameters();
                mutableRenderParameters.setValues(this._getParameterName(portletSerializable), portletSerializable.serialize());
            }
        }
        if (this._portletResponse instanceof RenderResponse) {
            PortletSession portletSession = this._portletRequest.getPortletSession(true);
            enumeration = portletSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                CDIScopedBean cdiScopedBean;
                String name = (String)enumeration.nextElement();
                Object value = portletSession.getAttribute(name);
                if (!(value instanceof CDIScopedBean) || !Objects.equals((cdiScopedBean = (CDIScopedBean)value).getScopeName(), RedirectScoped.class.getSimpleName())) continue;
                cdiScopedBean.destroy();
                portletSession.removeAttribute(name);
            }
        }
        Enumeration enumeration2 = this._portletRequest.getAttributeNames();
        while (enumeration2.hasMoreElements()) {
            String name = (String)enumeration2.nextElement();
            if (!name.startsWith(_ATTRIBUTE_NAME_PREFIX)) continue;
            Object value = this._portletRequest.getAttribute(name);
            if (value != null && value instanceof ScopedBean) {
                ScopedBean scopedBean = (ScopedBean)value;
                scopedBean.destroy();
            }
            this._portletRequest.removeAttribute(name);
        }
    }

    public PortletConfig getPortletConfig() {
        return this._portletConfig;
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public <T> T getPortletRequestScopedBean(Bean<T> bean, CreationalContext<T> creationalContext) {
        String name = this._getAttributeName(bean);
        CDIScopedBean<T> scopedBean = (CDIScopedBean<T>)this._portletRequest.getAttribute(name);
        if (scopedBean == null) {
            if (creationalContext == null) {
                return null;
            }
            scopedBean = new CDIScopedBean<T>(bean, creationalContext, name, PortletRequestScoped.class.getSimpleName());
            this._portletRequest.setAttribute(name, scopedBean);
        }
        return (T)scopedBean.getContainerCreatedInstance();
    }

    public PortletResponse getPortletResponse() {
        return this._portletResponse;
    }

    public <T> T getPortletSessionScopedBean(int subscope, Bean<T> bean, CreationalContext<T> creationalContext) {
        String name;
        PortletSession portletSession = this._portletRequest.getPortletSession(true);
        CDIScopedBean<T> scopedBean = (CDIScopedBean<T>)portletSession.getAttribute(name = this._getAttributeName(bean), subscope);
        if (scopedBean == null) {
            if (creationalContext == null) {
                return null;
            }
            scopedBean = new CDIScopedBean<T>(bean, creationalContext, name, PortletSessionScoped.class.getSimpleName());
            portletSession.setAttribute(name, scopedBean, subscope);
        }
        return (T)scopedBean.getContainerCreatedInstance();
    }

    public <T> T getRedirectScopedBean(Bean<T> bean, CreationalContext<T> creationalContext) {
        String name;
        PortletSession portletSession = this._portletRequest.getPortletSession(true);
        CDIScopedBean<T> scopedBean = (CDIScopedBean<T>)portletSession.getAttribute(name = this._getAttributeName(bean));
        if (scopedBean == null) {
            if (creationalContext == null) {
                return null;
            }
            scopedBean = new CDIScopedBean<T>(bean, creationalContext, name, RedirectScoped.class.getSimpleName());
            portletSession.setAttribute(name, scopedBean);
        }
        return (T)scopedBean.getContainerCreatedInstance();
    }

    public <T> T getRenderStateScopedBean(Bean<T> bean, CreationalContext<T> creationalContext) {
        String name = this._getAttributeName(bean);
        CDIScopedBean<T> scopedBean = (CDIScopedBean<T>)this._portletRequest.getAttribute(name);
        if (scopedBean == null) {
            if (creationalContext == null) {
                return null;
            }
            scopedBean = new CDIScopedBean<T>(bean, creationalContext, name, RenderStateScoped.class.getSimpleName());
            PortletSerializable portletSerializable = (PortletSerializable)scopedBean.getContainerCreatedInstance();
            String parameterName = this._getParameterName(portletSerializable);
            RenderParameters renderParameters = this._portletRequest.getRenderParameters();
            String[] parameterValues = renderParameters.getValues(parameterName);
            if (parameterValues == null) {
                parameterValues = new String[]{};
            }
            portletSerializable.deserialize(parameterValues);
            this._portletRequest.setAttribute(name, scopedBean);
        }
        return (T)scopedBean.getContainerCreatedInstance();
    }

    private String _getAttributeName(Bean<?> bean) {
        String attributeName = bean.getName();
        if (attributeName == null || attributeName.isEmpty()) {
            Class beanClass = bean.getBeanClass();
            attributeName = beanClass.getName();
        }
        return _ATTRIBUTE_NAME_PREFIX.concat(attributeName);
    }

    private String _getParameterName(PortletSerializable portletSerializable) {
        String parameterName = null;
        Class beanClass = portletSerializable.getClass();
        RenderStateScoped renderStateScoped = beanClass.getAnnotation(RenderStateScoped.class);
        if (renderStateScoped != null) {
            parameterName = renderStateScoped.paramName();
        }
        if (parameterName == null || parameterName.isEmpty()) {
            parameterName = beanClass.getSimpleName();
        }
        return parameterName;
    }
}

