/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.UriInfoImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.mvc.Models;
import javax.mvc.engine.ViewEngineContext;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public class ViewEngineContextImpl
implements ViewEngineContext {
    private static final Log _log = LogFactoryUtil.getLog(ViewEngineContextImpl.class);
    private final Configuration _configuration;
    private final Locale _locale;
    private MediaType _mediaType;
    private final MimeResponse _mimeResponse;
    private final Models _models;
    private final PortletRequest _portletRequest;

    public ViewEngineContextImpl(Configuration configuration, Locale locale, MimeResponse mimeResponse, Models models, PortletRequest portletRequest) {
        this._configuration = configuration;
        this._locale = locale;
        this._mimeResponse = mimeResponse;
        this._models = models;
        this._portletRequest = portletRequest;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public MediaType getMediaType() {
        if (this._mediaType == null) {
            String contentType = this._mimeResponse.getContentType();
            if (contentType == null) {
                this._mediaType = MediaType.TEXT_HTML_TYPE;
            } else {
                String type = contentType;
                String subtype = null;
                int pos = contentType.indexOf(47);
                if (pos > 0) {
                    type = contentType.substring(0, pos);
                    subtype = contentType.substring(pos + 1);
                }
                this._mediaType = new MediaType(type, subtype, this._mimeResponse.getCharacterEncoding());
            }
        }
        return this._mediaType;
    }

    public Models getModels() {
        return this._models;
    }

    public OutputStream getOutputStream() {
        try {
            return this._mimeResponse.getPortletOutputStream();
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
            return null;
        }
    }

    public <T> T getRequest(Class<T> type) {
        return type.cast(this._portletRequest);
    }

    public ResourceInfo getResourceInfo() {
        throw new UnsupportedOperationException();
    }

    public <T> T getResponse(Class<T> type) {
        return type.cast(this._mimeResponse);
    }

    public MultivaluedMap<String, Object> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl();
    }

    public String getView() {
        return (String)this._portletRequest.getAttribute("viewName");
    }
}

