/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanUtil;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BindingErrorImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.MutableBindingResult;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ParamConverterProviders;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.PortletParam;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.portlet.PortletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Dependent
public class PortletParamProducer {
    private static final Log _log = LogFactoryUtil.getLog(PortletParamProducer.class);
    @Inject
    private BeanManager _beanManager;
    @Inject
    @ParamConverterProviders
    private List<ParamConverterProvider> _paramConverterProviders;

    @Dependent
    @PortletParam
    @Produces
    public Boolean getBooleanParam(InjectionPoint injectionPoint, PortletRequest portletRequest) {
        String value = this.getStringParam(injectionPoint, portletRequest);
        if (value == null) {
            return null;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        Annotation[] fieldAnnotations = this._getFieldAnnotations(annotated);
        ParamConverter<Boolean> paramConverter = this._getParamConverter(fieldAnnotations, annotated.getBaseType(), Boolean.class);
        if (paramConverter != null) {
            try {
                return (Boolean)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(fieldAnnotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Boolean");
        }
        return null;
    }

    @Dependent
    @PortletParam
    @Produces
    public Date getDateParam(InjectionPoint injectionPoint, PortletRequest portletRequest) {
        String value = this.getStringParam(injectionPoint, portletRequest);
        if (value == null) {
            return null;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        Annotation[] fieldAnnotations = this._getFieldAnnotations(annotated);
        ParamConverter<Date> paramConverter = this._getParamConverter(fieldAnnotations, annotated.getBaseType(), Date.class);
        if (paramConverter != null) {
            try {
                return (Date)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(fieldAnnotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Date");
        }
        return null;
    }

    @Dependent
    @PortletParam
    @Produces
    public Double getDoubleParam(InjectionPoint injectionPoint, PortletRequest portletRequest) {
        String value = this.getStringParam(injectionPoint, portletRequest);
        if (value == null) {
            return null;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        Annotation[] fieldAnnotations = this._getFieldAnnotations(annotated);
        ParamConverter<Double> paramConverter = this._getParamConverter(fieldAnnotations, annotated.getBaseType(), Double.class);
        if (paramConverter != null) {
            try {
                return (Double)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(fieldAnnotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Double");
        }
        return null;
    }

    @Dependent
    @PortletParam
    @Produces
    public Float getFloatParam(InjectionPoint injectionPoint, PortletRequest portletRequest) {
        String value = this.getStringParam(injectionPoint, portletRequest);
        if (value == null) {
            return null;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        Annotation[] fieldAnnotations = this._getFieldAnnotations(annotated);
        ParamConverter<Float> paramConverter = this._getParamConverter(fieldAnnotations, annotated.getBaseType(), Float.class);
        if (paramConverter != null) {
            try {
                return (Float)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(fieldAnnotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Float");
        }
        return null;
    }

    @Dependent
    @PortletParam
    @Produces
    public Integer getIntegerParam(InjectionPoint injectionPoint, PortletRequest portletRequest) {
        String value = this.getStringParam(injectionPoint, portletRequest);
        if (value == null) {
            return null;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        Annotation[] fieldAnnotations = this._getFieldAnnotations(annotated);
        ParamConverter<Integer> paramConverter = this._getParamConverter(fieldAnnotations, annotated.getBaseType(), Integer.class);
        if (paramConverter != null) {
            try {
                return (Integer)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(fieldAnnotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Integer");
        }
        return null;
    }

    @Dependent
    @PortletParam
    @Produces
    public Long getLongParam(InjectionPoint injectionPoint, PortletRequest portletRequest) {
        String value = this.getStringParam(injectionPoint, portletRequest);
        if (value == null) {
            return null;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        Annotation[] fieldAnnotations = this._getFieldAnnotations(annotated);
        ParamConverter<Long> paramConverter = this._getParamConverter(fieldAnnotations, annotated.getBaseType(), Long.class);
        if (paramConverter != null) {
            try {
                return (Long)paramConverter.fromString(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._addBindingError(fieldAnnotations, illegalArgumentException.getMessage(), value);
                return null;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to find a ParamConverterProvider for type Long");
        }
        return Long.valueOf(value);
    }

    @Dependent
    @PortletParam
    @Produces
    public String getStringParam(InjectionPoint injectionPoint, PortletRequest portletRequest) {
        CookieParam cookieParam;
        Annotated annotated = injectionPoint.getAnnotated();
        String defaultValue = null;
        DefaultValue defaultValueAnnotation = (DefaultValue)annotated.getAnnotation(DefaultValue.class);
        if (defaultValueAnnotation != null) {
            defaultValue = defaultValueAnnotation.value();
        }
        if ((cookieParam = (CookieParam)annotated.getAnnotation(CookieParam.class)) != null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = portletRequest.getCookies()) {
                if (!Objects.equals(cookieParam.value(), cookie.getName())) continue;
                String cookieValue = cookie.getValue();
                if (cookieValue == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into a annotated annotated with ", "@CookieParam(\"", cookieParam.value(), "\") because the cookie does not have a ", "value"}));
                    }
                    return defaultValue;
                }
                return cookieValue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into a annotated annotated with @CookieParam(\"", cookieParam.value(), "\") because there is no cookie ", "with that name"}));
            }
            return defaultValue;
        }
        FormParam formParam = (FormParam)annotated.getAnnotation(FormParam.class);
        if (formParam != null) {
            String lifecyclePhase = (String)portletRequest.getAttribute("javax.portlet.lifecycle_phase");
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            HttpServletRequest httpServletRequest = themeDisplay.getRequest();
            String httpMethod = httpServletRequest.getMethod();
            if (StringUtil.equalsIgnoreCase((String)httpMethod, (String)"post") && (lifecyclePhase.equals("ACTION_PHASE") || lifecyclePhase.equals("RESOURCE_PHASE"))) {
                String parameterValue = portletRequest.getParameter(formParam.value());
                if (parameterValue == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into a annotated annotated with ", "@FormParam(\"", formParam.value(), "\") because the request parameter does not ", "have a value"}));
                    }
                    return defaultValue;
                }
                return parameterValue;
            }
            if (_log.isDebugEnabled()) {
                if (lifecyclePhase.equals("RENDER_PHASE")) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Injection into a annotated annotated with ", "@FormParam(\"", formParam.value(), "\") is ", "invalid during the RENDER_PHASE"}));
                } else {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Injection into a annotated annotated with ", "@FormParam(\"", formParam.value(), "\") is ", "invalid during the ", lifecyclePhase, " (HTTP ", httpMethod, ") request"}));
                }
            }
            return null;
        }
        HeaderParam headerParam = (HeaderParam)annotated.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            Enumeration enumeration = portletRequest.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String propertyName = (String)enumeration.nextElement();
                if (!Objects.equals(headerParam.value(), propertyName)) continue;
                String headerValue = portletRequest.getProperty(propertyName);
                if (headerValue == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into a annotated annotated with ", "@HeaderParam(\"", headerParam.value(), "\") because the header does not have a ", "value"}));
                    }
                    return defaultValue;
                }
                return headerValue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into a annotated annotated with @HeaderParam(\"", headerParam.value(), "\") because there is no header with that name"}));
            }
            return defaultValue;
        }
        QueryParam queryParam = (QueryParam)annotated.getAnnotation(QueryParam.class);
        if (queryParam != null) {
            String parameterValue = portletRequest.getParameter(queryParam.value());
            if (parameterValue == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Injecting the default value \"", defaultValue, "\" into a annotated annotated with @QueryParam(\"", queryParam.value(), "\") because the request parameter does not have ", "a value"}));
                }
                return defaultValue;
            }
            return parameterValue;
        }
        return defaultValue;
    }

    private void _addBindingError(Annotation[] fieldAnnotations, String message, String value) {
        MutableBindingResult mutableBindingResult = BeanUtil.getMutableBindingResult(this._beanManager);
        if (mutableBindingResult == null) {
            _log.error((Object)"Unable to add a binding error");
        } else {
            mutableBindingResult.addBindingError(new BindingErrorImpl(message, this._getParamName(fieldAnnotations), value));
        }
    }

    private Annotation[] _getFieldAnnotations(Annotated annotated) {
        Set annotations = annotated.getAnnotations();
        return annotations.toArray(new Annotation[0]);
    }

    private <T> ParamConverter<T> _getParamConverter(Annotation[] annotations, Type baseType, Class<T> rawType) {
        for (ParamConverterProvider paramConverterProvider : this._paramConverterProviders) {
            ParamConverter paramConverter = paramConverterProvider.getConverter(rawType, baseType, annotations);
            if (paramConverter == null) continue;
            return paramConverter;
        }
        return null;
    }

    private String _getParamName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<?> annotationClass = annotation.getClass();
            if (CookieParam.class.isAssignableFrom(annotationClass)) {
                CookieParam cookieParam = (CookieParam)annotation;
                return cookieParam.value();
            }
            if (FormParam.class.isAssignableFrom(annotationClass)) {
                FormParam formParam = (FormParam)annotation;
                return formParam.value();
            }
            if (HeaderParam.class.isAssignableFrom(annotationClass)) {
                HeaderParam headerParam = (HeaderParam)annotation;
                return headerParam.value();
            }
            if (!QueryParam.class.isAssignableFrom(annotationClass)) continue;
            QueryParam queryParam = (QueryParam)annotation;
            return queryParam.value();
        }
        return null;
    }
}

