/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.scope.ScopedBeanManager;
import com.liferay.bean.portlet.cdi.extension.internal.scope.ScopedBeanManagerThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.function.Function;
import javax.portlet.PortletRequest;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class ParamConverterProviderImpl
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType == null) {
            return null;
        }
        if (!(rawType.equals(Integer.class) || rawType.equals(Integer.TYPE) || rawType.equals(Long.class) || rawType.equals(Long.TYPE) || rawType.equals(Double.class) || rawType.equals(Double.TYPE) || rawType.equals(Float.class) || rawType.equals(Float.TYPE) || rawType.equals(Boolean.class) || rawType.equals(Boolean.TYPE))) {
            return null;
        }
        return new ParamConverter<T>(){

            public T fromString(String value) {
                if (value == null) {
                    throw new IllegalArgumentException("Unable to convert a null parameter value");
                }
                if (rawType.equals(Integer.class) || rawType.equals(Integer.TYPE)) {
                    return this._getNumber(value, number -> number.intValue());
                }
                if (rawType.equals(Long.class) || rawType.equals(Long.TYPE)) {
                    return this._getNumber(value, number -> number.longValue());
                }
                if (rawType.equals(Double.class) || rawType.equals(Double.TYPE)) {
                    return this._getNumber(value, number -> number.doubleValue());
                }
                if (rawType.equals(Float.class) || rawType.equals(Float.TYPE)) {
                    return this._getNumber(value, number -> Float.valueOf(number.floatValue()));
                }
                if (rawType.equals(Boolean.class) || rawType.equals(Boolean.TYPE)) {
                    value = value.trim();
                    if (Boolean.valueOf(value = StringUtil.toLowerCase((String)value)).booleanValue()) {
                        return rawType.cast(Boolean.TRUE);
                    }
                    return rawType.cast(value.equals("on"));
                }
                return null;
            }

            public String toString(T value) {
                if (value == null) {
                    return "";
                }
                return value.toString();
            }

            private T _getNumber(String value, Function<Number, ?> getNumberFunction) {
                ScopedBeanManager scopedBeanManager = ScopedBeanManagerThreadLocal.getCurrentScopedBeanManager();
                PortletRequest portletRequest = scopedBeanManager.getPortletRequest();
                NumberFormat numberFormat = NumberFormat.getInstance(portletRequest.getLocale());
                try {
                    Number number = numberFormat.parse(value);
                    return rawType.cast(getNumberFunction.apply(number));
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(parseException);
                }
            }
        };
    }
}

