/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.BaseDescendingPriorityComparator;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanUtil;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.LocaleResolverImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.MVCContextImpl;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mvc.MvcContext;
import javax.mvc.locale.LocaleResolver;
import javax.mvc.security.Encoders;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.annotations.PortletRequestScoped;
import javax.ws.rs.core.Configuration;

@ApplicationScoped
public class MVCContextProducer {
    @Inject
    private BeanManager _beanManager;
    private List<LocaleResolver> _localeResolvers;

    @Named(value="mvc")
    @PortletRequestScoped
    @Produces
    public MvcContext getMvcContext(Configuration configuration, Encoders encoders, PortletContext portletContext, PortletRequest portletRequest) {
        return new MVCContextImpl(configuration, encoders, this._localeResolvers, portletContext, portletRequest);
    }

    @PostConstruct
    public void postConstruct() {
        this._localeResolvers = BeanUtil.getBeanInstances(this._beanManager, LocaleResolver.class, new Annotation[0]);
        this._localeResolvers.add(new LocaleResolverImpl());
        Collections.sort(this._localeResolvers, new LocaleResolverPriorityComparator());
    }

    private static class LocaleResolverPriorityComparator
    extends BaseDescendingPriorityComparator<LocaleResolver> {
        private LocaleResolverPriorityComparator() {
            super(1000);
        }
    }
}

