/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanUtil;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanValidationInterceptorBinding;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanValidationMessageInterpolator;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanValidationValidator;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.MessageInterpolatorContextImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.MutableBindingResult;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ValidationErrorImpl;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.mvc.MvcContext;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Validator;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;

@BeanValidationInterceptorBinding
@Interceptor
@Priority(value=1000)
public class BeanValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = 2378576156374329311L;
    @Inject
    private BeanManager _beanManager;
    @BeanValidationMessageInterpolator
    @Inject
    private MessageInterpolator _messageInterpolator;
    @Inject
    private MvcContext _mvcContext;
    @BeanValidationValidator
    @Inject
    private Validator _validator;

    /*
     * WARNING - void declaration
     */
    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext invocationContext) throws Exception {
        if (this._validator == null) {
            return invocationContext.proceed();
        }
        Set constraintViolations = this._validator.validate(invocationContext.getTarget(), new Class[0]);
        for (ConstraintViolation constraintViolation : constraintViolations) {
            void var14_16;
            Annotation[] annotations;
            PropertyDescriptor[] propertyDescriptors;
            Path propertyPath = constraintViolation.getPropertyPath();
            Path.Node lastPathNode = null;
            Iterator iterator = propertyPath.iterator();
            while (iterator.hasNext()) {
                Path.Node pathNode;
                lastPathNode = pathNode = (Path.Node)iterator.next();
            }
            if (lastPathNode == null || lastPathNode.getKind() != ElementKind.PROPERTY) continue;
            Object leafBean = constraintViolation.getLeafBean();
            Class leafBeanClass = leafBean.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(leafBean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyDescriptorName = propertyDescriptor.getName();
                if (!propertyDescriptorName.equals("targetClass")) continue;
                Method method = propertyDescriptor.getReadMethod();
                leafBeanClass = (Class)method.invoke(leafBean, new Object[0]);
            }
            Field field = leafBeanClass.getDeclaredField(lastPathNode.getName());
            String paramName = null;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (annotation instanceof CookieParam) {
                    CookieParam cookieParam = (CookieParam)annotation;
                    paramName = cookieParam.value();
                    break;
                }
                if (annotation instanceof FormParam) {
                    FormParam formParam = (FormParam)annotation;
                    paramName = formParam.value();
                    break;
                }
                if (annotation instanceof HeaderParam) {
                    HeaderParam headerParam = (HeaderParam)annotation;
                    paramName = headerParam.value();
                    break;
                }
                if (!(annotation instanceof QueryParam)) continue;
                QueryParam queryParam = (QueryParam)annotation;
                paramName = queryParam.value();
            }
            String string = constraintViolation.getMessage();
            if (this._messageInterpolator != null) {
                String string2 = this._messageInterpolator.interpolate(constraintViolation.getMessageTemplate(), (MessageInterpolator.Context)new MessageInterpolatorContextImpl(constraintViolation), this._mvcContext.getLocale());
            }
            MutableBindingResult mutableBindingResult = BeanUtil.getMutableBindingResult(this._beanManager);
            mutableBindingResult.addValidationError(new ValidationErrorImpl(constraintViolation, (String)var14_16, paramName));
        }
        return invocationContext.proceed();
    }
}

