/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal;

import com.liferay.bean.portlet.cdi.extension.internal.CDIBeanFilterMethodFactory;
import com.liferay.bean.portlet.cdi.extension.internal.CDIBeanPortletMethodFactory;
import com.liferay.bean.portlet.cdi.extension.internal.PortletAsyncScopeManagerImpl;
import com.liferay.bean.portlet.cdi.extension.internal.annotated.type.ModifiedAnnotatedType;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.MVCExtension;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ViewRendererMVCImpl;
import com.liferay.bean.portlet.cdi.extension.internal.scope.JSR362CDIBeanProducer;
import com.liferay.bean.portlet.cdi.extension.internal.scope.PortletRequestBeanContext;
import com.liferay.bean.portlet.cdi.extension.internal.scope.PortletSessionBeanContext;
import com.liferay.bean.portlet.cdi.extension.internal.scope.RenderStateBeanContext;
import com.liferay.bean.portlet.cdi.extension.internal.scope.ScopedBeanManager;
import com.liferay.bean.portlet.cdi.extension.internal.scope.ScopedBeanManagerThreadLocal;
import com.liferay.bean.portlet.cdi.extension.internal.scope.ServletContextProducer;
import com.liferay.bean.portlet.extension.BeanFilterMethod;
import com.liferay.bean.portlet.extension.BeanFilterMethodFactory;
import com.liferay.bean.portlet.extension.BeanFilterMethodInvoker;
import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.extension.BeanPortletMethodDecorator;
import com.liferay.bean.portlet.extension.BeanPortletMethodFactory;
import com.liferay.bean.portlet.extension.BeanPortletMethodInvoker;
import com.liferay.bean.portlet.extension.BeanPortletMethodType;
import com.liferay.bean.portlet.extension.ScopedBean;
import com.liferay.bean.portlet.extension.ViewRenderer;
import com.liferay.bean.portlet.registration.util.BeanPortletRegistrarUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.async.PortletAsyncListenerFactory;
import com.liferay.portal.kernel.portlet.async.PortletAsyncScopeManagerFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.portlet.ActionParameters;
import javax.portlet.ActionRequest;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletAsyncListener;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.annotations.ContextPath;
import javax.portlet.annotations.Namespace;
import javax.portlet.annotations.PortletName;
import javax.portlet.annotations.PortletRequestScoped;
import javax.portlet.annotations.PortletSerializable;
import javax.portlet.annotations.PortletSessionScoped;
import javax.portlet.annotations.RenderStateScoped;
import javax.portlet.annotations.WindowId;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class CDIBeanPortletExtension
implements Extension {
    private static final String _ENGLISH_EN = LocaleUtil.ENGLISH.getLanguage();
    private static final Log _log = LogFactoryUtil.getLog(CDIBeanPortletExtension.class);
    private static final Annotation _applicationScoped = new ApplicationScoped(){

        public Class<? extends Annotation> annotationType() {
            return ApplicationScoped.class;
        }
    };
    private static final Annotation _portletRequestScoped = new PortletRequestScoped(){

        public Class<? extends Annotation> annotationType() {
            return PortletRequestScoped.class;
        }
    };
    private static final Annotation _portletSessionScoped = new PortletSessionScoped(){

        public Class<? extends Annotation> annotationType() {
            return PortletSessionScoped.class;
        }

        public int value() {
            return 2;
        }
    };
    private final Set<Class<?>> _discoveredClasses = new HashSet();
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
    private ViewRenderer _viewRenderer;

    public void step1BeforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Scanning for bean portlets and bean filters");
        }
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(JSR362CDIBeanProducer.class), null);
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(ServletContextProducer.class), null);
        beforeBeanDiscovery.addQualifier(ContextPath.class);
        beforeBeanDiscovery.addQualifier(Namespace.class);
        beforeBeanDiscovery.addQualifier(PortletName.class);
        beforeBeanDiscovery.addQualifier(WindowId.class);
        beforeBeanDiscovery.addScope(PortletRequestScoped.class, true, false);
        beforeBeanDiscovery.addScope(PortletSessionScoped.class, true, true);
        beforeBeanDiscovery.addScope(RenderStateScoped.class, true, false);
        MVCExtension.step1BeforeBeanDiscovery(beanManager, beforeBeanDiscovery);
    }

    public <T> void step2ProcessAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedType) {
        HashSet<Type> types;
        HashSet<Annotation> annotations;
        PortletSessionScoped portletSessionScoped;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("processAnnotatedType=" + String.valueOf(processAnnotatedType)));
        }
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class discoveredClass = annotatedType.getJavaClass();
        if (annotatedType.isAnnotationPresent(RenderStateScoped.class) && !PortletSerializable.class.isAssignableFrom(discoveredClass) && _log.isWarnEnabled()) {
            _log.warn((Object)(discoveredClass.getName() + " does not implement " + PortletSerializable.class.getName()));
        }
        if (_log.isWarnEnabled() && (portletSessionScoped = (PortletSessionScoped)annotatedType.getAnnotation(PortletSessionScoped.class)) != null && 1 != portletSessionScoped.value() && 2 != portletSessionScoped.value()) {
            _log.warn((Object)"@PortletSessionScoped bean can only be PortletSession.APPLICATION_SCOPE or PortletSession.PORTLET_SCOPE");
        }
        if ((annotations = new HashSet<Annotation>(annotatedType.getAnnotations())).remove(annotatedType.getAnnotation(RequestScoped.class)) && !annotatedType.isAnnotationPresent(PortletRequestScoped.class)) {
            annotations.add(_portletRequestScoped);
        }
        if (annotations.remove(annotatedType.getAnnotation(SessionScoped.class)) && !annotatedType.isAnnotationPresent(PortletSessionScoped.class)) {
            annotations.add(_portletSessionScoped);
        }
        if (Portlet.class.isAssignableFrom(discoveredClass) && !annotatedType.isAnnotationPresent(ApplicationScoped.class)) {
            annotations.remove(annotatedType.getAnnotation(ConversationScoped.class));
            annotations.remove(annotatedType.getAnnotation(PortletRequestScoped.class));
            annotations.remove(annotatedType.getAnnotation(PortletSessionScoped.class));
            annotations.remove(annotatedType.getAnnotation(RequestScoped.class));
            annotations.remove(annotatedType.getAnnotation(SessionScoped.class));
            annotations.add(_applicationScoped);
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Automatically added @ApplicationScoped to " + String.valueOf(discoveredClass)));
            }
        }
        if ((types = new HashSet<Type>(annotatedType.getTypeClosure())).remove(PortletConfig.class) || !annotations.equals(annotatedType.getAnnotations())) {
            processAnnotatedType.setAnnotatedType(new ModifiedAnnotatedType(annotatedType, annotations, types));
        }
        this._discoveredClasses.add(discoveredClass);
        MVCExtension.step2ProcessAnnotatedType(processAnnotatedType);
    }

    public void step3AfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        afterBeanDiscovery.addContext((Context)new PortletRequestBeanContext());
        afterBeanDiscovery.addContext((Context)new PortletSessionBeanContext());
        afterBeanDiscovery.addContext((Context)new RenderStateBeanContext());
        MVCExtension.step3AfterBeanDiscovery(afterBeanDiscovery);
    }

    public void step4ApplicationScopedInitializedAsync(@ObservesAsync ServletContext servletContext, final BeanManager beanManager, BundleContext bundleContext) {
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"servlet.context.name", (Object)servletContext.getServletContextName()).build();
        this._serviceRegistrations.add(bundleContext.registerService(PortletAsyncScopeManagerFactory.class, PortletAsyncScopeManagerImpl::new, (Dictionary)properties));
        this._serviceRegistrations.add(bundleContext.registerService(PortletAsyncListenerFactory.class, (Object)new PortletAsyncListenerFactory(){

            public <T extends PortletAsyncListener> T getPortletAsyncListener(Class<T> clazz) throws PortletException {
                Bean bean = beanManager.resolve(beanManager.getBeans(clazz, new Annotation[0]));
                if (bean == null) {
                    throw new PortletException("Unable to create an instance of " + clazz.getName());
                }
                try {
                    return (T)((PortletAsyncListener)clazz.cast(beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean))));
                }
                catch (Exception exception) {
                    throw new PortletException("Unable to create an instance of " + clazz.getName(), (Throwable)exception);
                }
            }
        }, (Dictionary)properties));
        BeanFilterMethodInvoker beanFilterMethodInvoker = new BeanFilterMethodInvoker(){

            public void invokeWithActiveScopes(BeanFilterMethod beanFilterMethod, Object filterChain, PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
                ScopedBeanManagerThreadLocal.invokeWithScopedBeanManager(() -> new ScopedBeanManager(null, portletRequest, portletResponse), () -> this._invokePortletFilterMethod(beanFilterMethod, portletRequest, portletResponse, filterChain));
            }

            private void _invokePortletFilterMethod(BeanFilterMethod beanFilterMethod, PortletRequest portletRequest, PortletResponse portletResponse, Object filterChain) throws PortletException {
                try {
                    beanFilterMethod.invoke(new Object[]{portletRequest, portletResponse, filterChain});
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new PortletException((Throwable)illegalAccessException);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    Throwable throwable = reflectiveOperationException.getCause();
                    if (throwable instanceof PortletException) {
                        throw (PortletException)throwable;
                    }
                    throw new PortletException(throwable);
                }
            }
        };
        BeanPortletMethodInvoker beanPortletMethodInvoker = new BeanPortletMethodInvoker(){

            public void invokeWithActiveScopes(List<BeanPortletMethod> beanPortletMethods, PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
                ScopedBeanManagerThreadLocal.invokeWithScopedBeanManager(() -> new ScopedBeanManager(portletConfig, portletRequest, portletResponse), () -> this._invokePortletBeanMethods(beanPortletMethods, portletRequest, portletResponse, portletConfig));
            }

            private void _invokePortletBeanMethods(List<BeanPortletMethod> beanPortletMethods, PortletRequest portletRequest, PortletResponse portletResponse, PortletConfig portletConfig) throws PortletException {
                for (BeanPortletMethod beanPortletMethod : beanPortletMethods) {
                    CDIBeanPortletExtension.this._invokeBeanPortletMethod(beanManager, beanPortletMethod, portletConfig, portletRequest, portletResponse);
                }
                if (portletResponse instanceof RenderResponse || portletResponse instanceof ResourceResponse) {
                    CDIBeanPortletExtension.this._viewRenderer.render((MimeResponse)portletResponse, portletConfig, portletRequest);
                }
            }
        };
        this._serviceRegistrations.addAll(BeanPortletRegistrarUtil.register((BeanFilterMethodFactory)new CDIBeanFilterMethodFactory(beanManager), (BeanFilterMethodInvoker)beanFilterMethodInvoker, (BeanPortletMethodFactory)new CDIBeanPortletMethodFactory(beanManager), (BeanPortletMethodInvoker)beanPortletMethodInvoker, this._discoveredClasses, (ServletContext)servletContext));
        Bean bean = beanManager.resolve(beanManager.getBeans(ViewRenderer.class, new Annotation[0]));
        if (bean == null) {
            Bundle bundle = bundleContext.getBundle();
            Dictionary headers = bundle.getHeaders(_ENGLISH_EN);
            String importPackageHeader = (String)headers.get("Import-Package");
            boolean importsMvcPackage = false;
            if (importPackageHeader.contains("javax.mvc;")) {
                importsMvcPackage = true;
            }
            boolean importsMvcBindingPackage = false;
            if (importPackageHeader.contains("javax.mvc.binding;")) {
                importsMvcBindingPackage = true;
            }
            this._viewRenderer = new ViewRendererMVCImpl(beanManager, importsMvcBindingPackage, importsMvcPackage);
        } else {
            this._viewRenderer = (ViewRenderer)beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean));
        }
    }

    public void step4ApplicationScopedInitializedSync(@Initialized(value=ApplicationScoped.class) @Observes ServletContext servletContext, BeanManager beanManager, Event<ServletContext> servletContextEvent) {
        servletContextEvent.fireAsync((Object)servletContext);
    }

    public void step5SessionScopeBeforeDestroyed(@Destroyed(value=SessionScoped.class) @Observes Object httpSessionObject) {
        HttpSession httpSession = (HttpSession)httpSessionObject;
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object value = httpSession.getAttribute(name);
            if (!(value instanceof ScopedBean)) continue;
            ScopedBean scopedBean = (ScopedBean)value;
            scopedBean.destroy();
        }
    }

    public void step6ApplicationScopedBeforeDestroyed(@Destroyed(value=ApplicationScoped.class) @Observes Object contextObject) {
        BeanPortletRegistrarUtil.unregister(this._serviceRegistrations, (ServletContext)((ServletContext)contextObject));
        this._serviceRegistrations.clear();
    }

    private void _invokeBeanPortletMethod(BeanManager beanManager, BeanPortletMethod beanPortletMethod, PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
        try {
            Bean bean = beanManager.resolve(beanManager.getBeans(BeanPortletMethodDecorator.class, new Annotation[0]));
            if (bean != null) {
                BeanPortletMethodDecorator beanPortletMethodDecorator = (BeanPortletMethodDecorator)beanManager.getReference(bean, BeanPortletMethodDecorator.class, beanManager.createCreationalContext((Contextual)bean));
                beanPortletMethod = beanPortletMethodDecorator.getBeanPortletMethod(beanPortletMethod, portletConfig, portletRequest, portletResponse);
            }
            String include = null;
            Method method = beanPortletMethod.getMethod();
            BeanPortletMethodType beanPortletMethodType = beanPortletMethod.getBeanPortletMethodType();
            if (beanPortletMethodType == BeanPortletMethodType.ACTION) {
                ActionRequest actionRequest = (ActionRequest)portletRequest;
                String actionName = null;
                PortletContext portletContext = portletConfig.getPortletContext();
                if (portletContext.getEffectiveMajorVersion() >= 3) {
                    ActionParameters actionParameters = actionRequest.getActionParameters();
                    actionName = actionParameters.getValue("javax.portlet.action");
                } else {
                    actionName = actionRequest.getParameter("javax.portlet.action");
                }
                String beanMethodActionName = beanPortletMethod.getActionName();
                if (Validator.isNull((String)beanMethodActionName) || beanMethodActionName.equals(actionName)) {
                    beanPortletMethod.invoke(new Object[]{portletRequest, portletResponse});
                }
            } else if (beanPortletMethodType == BeanPortletMethodType.HEADER || beanPortletMethodType == BeanPortletMethodType.RENDER) {
                PortletMode portletMode = portletRequest.getPortletMode();
                PortletMode beanMethodPortletMode = beanPortletMethod.getPortletMode();
                if (beanMethodPortletMode == null || portletMode.equals((Object)beanMethodPortletMode)) {
                    if (method.getParameterCount() == 0) {
                        String markup = (String)beanPortletMethod.invoke(new Object[0]);
                        if (markup != null) {
                            MimeResponse mimeResponse = (MimeResponse)portletResponse;
                            PrintWriter printWriter = mimeResponse.getWriter();
                            printWriter.write(markup);
                        }
                    } else {
                        beanPortletMethod.invoke(new Object[]{portletRequest, portletResponse});
                    }
                    include = beanPortletMethodType.getInclude(method);
                }
            } else if (beanPortletMethodType == BeanPortletMethodType.SERVE_RESOURCE) {
                ResourceRequest resourceRequest = (ResourceRequest)portletRequest;
                String resourceID = resourceRequest.getResourceID();
                String beanMethodResourceID = beanPortletMethod.getResourceID();
                if (Validator.isNull((String)beanMethodResourceID) || beanMethodResourceID.equals(resourceID)) {
                    String characterEncoding;
                    ResourceResponse resourceResponse = (ResourceResponse)portletResponse;
                    String contentType = beanPortletMethodType.getContentType(method);
                    if (Validator.isNotNull((String)contentType) && !Objects.equals(contentType, "*/*")) {
                        resourceResponse.setContentType(contentType);
                    }
                    if (Validator.isNotNull((String)(characterEncoding = beanPortletMethodType.getCharacterEncoding(method)))) {
                        resourceResponse.setCharacterEncoding(characterEncoding);
                    }
                    if (method.getParameterCount() == 0) {
                        String markup = (String)beanPortletMethod.invoke(new Object[0]);
                        if (Validator.isNotNull((String)markup)) {
                            PrintWriter printWriter = resourceResponse.getWriter();
                            printWriter.write(markup);
                        }
                    } else {
                        beanPortletMethod.invoke(new Object[]{resourceRequest, resourceResponse});
                    }
                    include = beanPortletMethodType.getInclude(method);
                }
            } else {
                beanPortletMethod.invoke(new Object[]{portletRequest, portletResponse});
            }
            PortletMode beanMethodPortletMode = beanPortletMethod.getPortletMode();
            if (Validator.isNotNull(include) && (beanMethodPortletMode == null || beanMethodPortletMode.equals((Object)portletRequest.getPortletMode()))) {
                PortletContext portletContext = portletConfig.getPortletContext();
                PortletRequestDispatcher requestDispatcher = portletContext.getRequestDispatcher(include);
                if (requestDispatcher == null) {
                    _log.error((Object)("Unable to acquire dispatcher to include " + include));
                } else {
                    requestDispatcher.include(portletRequest, portletResponse);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof PortletException) {
                throw (PortletException)throwable;
            }
            throw new PortletException(throwable);
        }
        catch (PortletException portletException) {
            throw portletException;
        }
        catch (Exception exception) {
            throw new PortletException((Throwable)exception);
        }
    }
}

