/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.service.impl;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalService;
import com.liferay.batch.engine.service.base.BatchEngineImportTaskServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=batchengine", "json.web.service.context.path=BatchEngineImportTask"}, service={AopService.class})
public class BatchEngineImportTaskServiceImpl
extends BatchEngineImportTaskServiceBaseImpl {
    @Reference
    private BatchEngineImportTaskErrorLocalService _batchEngineImportTaskErrorLocalService;

    public BatchEngineImportTask addBatchEngineImportTask(String externalReferenceCode, long companyId, long userId, long batchSize, String callbackURL, String className, byte[] content, String contentType, String executeStatus, Map<String, String> fieldNameMappingMap, int importStrategy, String operation, Map<String, Serializable> parameters, String taskItemDelegateName) throws PortalException {
        this._checkPermission(companyId);
        return this.batchEngineImportTaskLocalService.addBatchEngineImportTask(externalReferenceCode, companyId, userId, batchSize, callbackURL, className, content, contentType, executeStatus, fieldNameMappingMap, importStrategy, operation, parameters, taskItemDelegateName);
    }

    public BatchEngineImportTask addBatchEngineImportTask(String externalReferenceCode, long companyId, long userId, long batchSize, String callbackURL, String className, byte[] content, String contentType, String executeStatus, Map<String, String> fieldNameMappingMap, int importStrategy, String operation, Map<String, Serializable> parameters, String taskItemDelegateName, BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate) throws PortalException {
        this._checkPermission(companyId);
        return this.batchEngineImportTaskLocalService.addBatchEngineImportTask(externalReferenceCode, companyId, userId, batchSize, callbackURL, className, content, contentType, executeStatus, fieldNameMappingMap, importStrategy, operation, parameters, taskItemDelegateName, batchEngineTaskItemDelegate);
    }

    public BatchEngineImportTask getBatchEngineImportTask(long batchEngineImportTaskId) throws PortalException {
        BatchEngineImportTask batchEngineImportTask = this.batchEngineImportTaskLocalService.getBatchEngineImportTask(batchEngineImportTaskId);
        this._checkPermission(batchEngineImportTask);
        return batchEngineImportTask;
    }

    public BatchEngineImportTask getBatchEngineImportTaskByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        this._checkPermission(companyId);
        BatchEngineImportTask batchEngineImportTask = this.batchEngineImportTaskLocalService.getBatchEngineImportTaskByExternalReferenceCode(externalReferenceCode, companyId);
        this._checkPermission(batchEngineImportTask);
        return batchEngineImportTask;
    }

    public List<BatchEngineImportTask> getBatchEngineImportTasks(long companyId, int start, int end) throws PortalException {
        this._checkPermission(companyId);
        return this._filterBatchEngineImportTasks(this.batchEngineImportTaskLocalService.getBatchEngineImportTasks(companyId, start, end));
    }

    public List<BatchEngineImportTask> getBatchEngineImportTasks(long companyId, int start, int end, OrderByComparator<BatchEngineImportTask> orderByComparator) throws PortalException {
        this._checkPermission(companyId);
        return this._filterBatchEngineImportTasks(this.batchEngineImportTaskLocalService.getBatchEngineImportTasks(companyId, start, end, orderByComparator));
    }

    public int getBatchEngineImportTasksCount(long companyId) throws PortalException {
        this._checkPermission(companyId);
        List<BatchEngineImportTask> filteredBatchEngineImportTasks = this._filterBatchEngineImportTasks(this.batchEngineImportTaskLocalService.getBatchEngineImportTasks(companyId, -1, -1));
        return filteredBatchEngineImportTasks.size();
    }

    public InputStream openContentInputStream(long batchEngineImportTaskId) throws PortalException {
        this._checkPermission(this.batchEngineImportTaskLocalService.getBatchEngineImportTask(batchEngineImportTaskId));
        return this.batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTaskId);
    }

    private void _checkPermission(BatchEngineImportTask batchEngineImportTask) throws PrincipalException {
        if (!this._hasPermission(batchEngineImportTask, this.getPermissionChecker())) {
            throw new PrincipalException();
        }
    }

    private void _checkPermission(long companyId) throws PrincipalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (companyId != permissionChecker.getCompanyId() && !permissionChecker.isOmniadmin()) {
            throw new PrincipalException();
        }
    }

    private List<BatchEngineImportTask> _filterBatchEngineImportTasks(List<BatchEngineImportTask> batchEngineImportTasks) throws PrincipalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        return TransformUtil.transform(batchEngineImportTasks, batchEngineImportTask -> {
            if (this._hasPermission((BatchEngineImportTask)batchEngineImportTask, permissionChecker)) {
                return batchEngineImportTask;
            }
            return null;
        });
    }

    private boolean _hasPermission(BatchEngineImportTask batchEngineImportTask, PermissionChecker permissionChecker) {
        return permissionChecker.isCompanyAdmin(batchEngineImportTask.getCompanyId()) || batchEngineImportTask.getUserId() == permissionChecker.getUserId();
    }
}

