/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.csv.ColumnDescriptorProvider;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.ColumnValuesExtractor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSBatchEngineExportTaskItemWriterImpl
implements BatchEngineExportTaskItemWriter {
    private final ColumnValuesExtractor _columnValuesExtractor;
    private final OutputStream _outputStream;
    private int _rowNum;
    private final Sheet _sheet;
    private final Workbook _workbook = new XSSFWorkbook();

    public XLSBatchEngineExportTaskItemWriterImpl(ColumnDescriptorProvider columnDescriptorProvider, long companyId, Map<String, ObjectValuePair<Field, Method>> fieldNameObjectValuePairs, List<String> fieldNames, OutputStream outputStream, String taskItemDelegateName) throws PortalException {
        if (fieldNames.isEmpty()) {
            throw new IllegalArgumentException("Field names are not set");
        }
        this._outputStream = outputStream;
        this._columnValuesExtractor = new ColumnValuesExtractor(columnDescriptorProvider, companyId, fieldNameObjectValuePairs, fieldNames, taskItemDelegateName);
        this._sheet = this._workbook.createSheet();
        this._write(this._columnValuesExtractor.getHeaders());
    }

    @Override
    public void close() throws IOException {
        this._workbook.write(this._outputStream);
        this._workbook.close();
        this._outputStream.close();
    }

    @Override
    public void write(Collection<?> items) throws Exception {
        for (Object item : items) {
            for (Object[] values : this._columnValuesExtractor.extractValues(item)) {
                this._write(values);
            }
        }
    }

    private void _write(Object[] values) {
        Row row = this._sheet.createRow(this._rowNum++);
        int column = 0;
        for (Object value : values) {
            Cell cell = row.createCell(column++);
            if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                cell.setCellValue(number.doubleValue());
                continue;
            }
            cell.setCellValue((String)value);
        }
    }
}

