/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.bundle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.batch.engine.unit.BatchEngineUnitMetaInfo;
import com.liferay.batch.engine.unit.BundleBatchEngineUnit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.Bundle;

public class ClassicBundleBatchEngineUnitImpl
implements BundleBatchEngineUnit {
    private BatchEngineUnitMetaInfo _batchEngineUnitMetaInfo;
    private final Bundle _bundle;
    private URL _configurationURL;
    private URL _dataURL;

    public ClassicBundleBatchEngineUnitImpl(Bundle bundle, List<URL> urls) {
        this._bundle = bundle;
        if (urls == null || urls.size() > 2) {
            return;
        }
        for (URL url : urls) {
            if (this._isBatchEngineConfiguration(url)) {
                this._configurationURL = url;
                continue;
            }
            this._dataURL = url;
        }
    }

    public BatchEngineUnitConfiguration getBatchEngineUnitConfiguration() throws IOException {
        try (InputStream inputStream = this._configurationURL.openStream();){
            ObjectMapper objectMapper = new ObjectMapper();
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = (BatchEngineUnitConfiguration)objectMapper.readValue(inputStream, BatchEngineUnitConfiguration.class);
            return batchEngineUnitConfiguration;
        }
    }

    public BatchEngineUnitMetaInfo getBatchEngineUnitMetaInfo() {
        return this._batchEngineUnitMetaInfo;
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public InputStream getConfigurationInputStream() throws IOException {
        return this._configurationURL.openStream();
    }

    public String getDataFileName() {
        return this._dataURL.getPath();
    }

    public InputStream getDataInputStream() throws IOException {
        return this._dataURL.openStream();
    }

    public String getFileName() {
        return this._bundle.toString();
    }

    public boolean isValid() {
        return this._configurationURL != null && this._dataURL != null;
    }

    public void setBatchEngineUnitMetaInfo(BatchEngineUnitMetaInfo batchEngineUnitMetaInfo) {
        this._batchEngineUnitMetaInfo = batchEngineUnitMetaInfo;
    }

    private boolean _isBatchEngineConfiguration(URL url) {
        if (url == null) {
            return false;
        }
        String bundlePath = url.getPath();
        return Objects.equals(bundlePath, "batch-engine.json") || bundlePath.endsWith("/batch-engine.json");
    }
}

